"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LocalCacheClass = void 0;
const operators_1 = require("rxjs/operators");
const cache_class_1 = require("./cache.class");
class LocalCacheClass extends cache_class_1.CacheClass {
    constructor(sS) {
        super();
        this.sS = sS;
        this.cacheKey = 'cacheKey';
        this.cacheCreatedDateKey = 'cacheCreatedDateKey';
        this.validityDays = 7;
        this.oneDayTimestamp = 86400000;
        try {
            const createdDate = sS.getItem(this.cacheCreatedDateKey);
            if (!createdDate)
                this.sS.saveItem(this.cacheCreatedDateKey, Date.now());
            else if (createdDate + this.validityDays * this.oneDayTimestamp <= Date.now()) {
                this.sS.saveItem(this.cacheCreatedDateKey, Date.now());
                this.sS.removeItem(this.cacheKey);
            }
            sS.getItemA(this.cacheKey).then((r) => {
                try {
                    for (const key in r) {
                        if (Object.prototype.hasOwnProperty.call(r, key)) {
                            this.setItem(key, r[key]);
                        }
                    }
                }
                catch (error) {
                    console.error(error);
                }
            });
        }
        catch (e) {
            console.error(e);
            this.sS.removeItem(this.cacheKey);
        }
    }
    saveToLocal() {
        // console.log('saving to cache', JSON.stringify(super.cache));
        this.sS.saveItemA(this.cacheKey, super.cache);
    }
    setItem(key, data) {
        super.setItem(key, data);
        this.saveToLocal();
    }
    getAndSet(key, addFunc) {
        // debugger;
        return super.getAndSet(key, addFunc).pipe((0, operators_1.tap)((r) => this.saveToLocal()));
    }
}
exports.LocalCacheClass = LocalCacheClass;
//# sourceMappingURL=local-cache.class.js.map