"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CacheClass = void 0;
const rxjs_1 = require("rxjs");
class CacheClass {
    constructor() {
        this._cache = {};
        this.has = (key) => !!this._cache[key];
        this.getItem = (key) => this._cache[key];
    }
    get cache() {
        return this._cache;
    }
    setItem(key, data) {
        this._cache[key] = data;
        // return this._cache;
    }
    getAndSet(key, newValue) {
        return new rxjs_1.Observable((next) => {
            next.next(this.getItem(key));
            if (newValue) {
                Promise.resolve(newValue).then(async (res) => {
                    this.setItem(key, res);
                    next.next(res);
                    next.complete();
                });
            }
            else
                next.complete();
        });
    }
}
exports.CacheClass = CacheClass;
//# sourceMappingURL=cache.class.js.map