"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Config = exports.Prototypes = void 0;
const tslib_1 = require("tslib");
const index_model_1 = require("../shared/models/index.model");
exports.Prototypes = tslib_1.__importStar(require("../shared/prototypes/prototypes"));
class Config {
    static { this.Optioner = [
        { num: 1, letter: 'a' },
        { num: 2, letter: 'b' },
        { num: 3, letter: 'c' },
        { num: 4, letter: 'd' },
        { num: 5, letter: 'e' },
        { num: 6, letter: 'f' },
        { num: 7, letter: 'g' },
        { num: 8, letter: 'h' },
        { num: 9, letter: 'i' },
        { num: 10, letter: 'j' },
    ]; }
    static { this.Months = [
        { id: 0, short: 'Jan', isoStr: '01', long: 'January' },
        { id: 1, short: 'Feb', isoStr: '02', long: 'February' },
        { id: 2, short: 'Mar', isoStr: '03', long: 'March' },
        { id: 3, short: 'Apr', isoStr: '04', long: 'April' },
        { id: 4, short: 'May', isoStr: '05', long: 'May' },
        { id: 5, short: 'Jun', isoStr: '06', long: 'June' },
        { id: 6, short: 'Jul', isoStr: '07', long: 'July' },
        { id: 7, short: 'Aug', isoStr: '08', long: 'August' },
        { id: 8, short: 'Sep', isoStr: '09', long: 'September' },
        { id: 9, short: 'Oct', isoStr: '10', long: 'October' },
        { id: 10, short: 'Nov', isoStr: '11', long: 'November' },
        { id: 11, short: 'Dec', isoStr: '12', long: 'December' },
    ]; }
    static { this.ShortMonthsMap = Config.Months.map((x) => ({
        ...x,
        _short: x.short?.toLowerCase(),
    })).toMap(x => x._short); }
    static { this.boolList = [
        { value: true, label: 'Yes' },
        { value: false, label: 'No' },
    ]; }
    static { this.Days = [
        { index: 0, day: index_model_1.Day.sunday },
        { index: 1, day: index_model_1.Day.monday },
        { index: 2, day: index_model_1.Day.tuesday },
        { index: 3, day: index_model_1.Day.wednesday },
        { index: 4, day: index_model_1.Day.thursday },
        { index: 5, day: index_model_1.Day.friday },
        { index: 6, day: index_model_1.Day.saturday },
    ]; }
    static { this.Numbers = [
        { num: 1, label: 'First' },
        { num: 2, label: 'Second' },
        { num: 3, label: 'Third' },
        { num: 4, label: 'Fourth' },
        { num: 5, label: 'Fifth' },
        { num: 6, label: 'Sixth' },
        { num: 7, label: 'Seventh' },
        { num: 8, label: 'Eighth' },
        { num: 9, label: 'Ninth' },
        { num: 10, label: 'Tenth' },
    ]; }
    static { this.sexes = ['Female', 'Male']; }
    static { this.Currency = '₦'; }
    static { this.TimeStampDay = 86400000; }
    static { this.TimeStampWeek = 604800000; }
    static { this.placeholderImage = `/assets/images/placeholder.jpg`; }
    static { this.periods = [
        { id: index_model_1.EPeriod.today, name: 'Today' },
        { id: index_model_1.EPeriod.week, name: 'This Week' },
        { id: index_model_1.EPeriod.month, name: 'This Month' },
        { id: index_model_1.EPeriod.year, name: 'This Year' },
    ]; }
    static { this.periodsWithAnnual = [
        { id: index_model_1.EPeriod.today, name: 'Today' },
        { id: index_model_1.EPeriod.week, name: 'This Week' },
        { id: index_model_1.EPeriod.month, name: 'This Month' },
        { id: index_model_1.EPeriod.annual, name: 'This Year' },
    ]; }
    static { this.periodAdverbs = [
        { id: index_model_1.EPeriod.daily, name: 'Daily' },
        { id: index_model_1.EPeriod.weekly, name: 'Weekly' },
        { id: index_model_1.EPeriod.monthly, name: 'Monthly' },
        { id: index_model_1.EPeriod.annually, name: 'Annually' },
    ]; }
    static { this.organisationPlaceholder = '{{org}}'; }
    static { this.states = [
        {
            isoCode: 'NG-FC',
            name: 'Abuja Federal Capital Territory',
        },
        { isoCode: 'NG-AB', name: 'Abia' },
        { isoCode: 'NG-AD', name: 'Adamawa' },
        { isoCode: 'NG-AK', name: 'Akwa Ibom' },
        { isoCode: 'NG-AN', name: 'Anambra' },
        { isoCode: 'NG-BA', name: 'Bauchi' },
        { isoCode: 'NG-BY', name: 'Bayelsa' },
        { isoCode: 'NG-BE', name: 'Benue' },
        { isoCode: 'NG-BO', name: 'Borno' },
        { isoCode: 'NG-CR', name: 'Cross River' },
        { isoCode: 'NG-DE', name: 'Delta' },
        { isoCode: 'NG-EB', name: 'Ebonyi' },
        { isoCode: 'NG-ED', name: 'Edo' },
        { isoCode: 'NG-EK', name: 'Ekiti' },
        { isoCode: 'NG-EN', name: 'Enugu' },
        { isoCode: 'NG-GO', name: 'Gombe' },
        { isoCode: 'NG-IM', name: 'Imo' },
        { isoCode: 'NG-JI', name: 'Jigawa' },
        { isoCode: 'NG-KD', name: 'Kaduna' },
        { isoCode: 'NG-KN', name: 'Kano' },
        { isoCode: 'NG-KT', name: 'Katsina' },
        { isoCode: 'NG-KE', name: 'Kebbi' },
        { isoCode: 'NG-KO', name: 'Kogi' },
        { isoCode: 'NG-KW', name: 'Kwara' },
        { isoCode: 'NG-LA', name: 'Lagos' },
        { isoCode: 'NG-NA', name: 'Nasarawa' },
        { isoCode: 'NG-NI', name: 'Niger' },
        { isoCode: 'NG-OG', name: 'Ogun' },
        { isoCode: 'NG-ON', name: 'Ondo' },
        { isoCode: 'NG-OS', name: 'Osun' },
        { isoCode: 'NG-OY', name: 'Oyo' },
        { isoCode: 'NG-PL', name: 'Plateau' },
        { isoCode: 'NG-RI', name: 'Rivers' },
        { isoCode: 'NG-SO', name: 'Sokoto' },
        { isoCode: 'NG-TA', name: 'Taraba' },
        { isoCode: 'NG-YO', name: 'Yobe' },
        { isoCode: 'NG-ZA', name: 'Zamfara' },
    ]; }
}
exports.Config = Config;
//# sourceMappingURL=index.config.js.map