"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TokenServiceModule = exports.TokenSessionService = exports.TokenService = void 0;
const common_1 = require("@nestjs/common");
const jwt_1 = require("@nestjs/jwt");
const utility_service_1 = require("./utility.service");
const environment_service_1 = require("./environment.service");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const token_session_entity_1 = require("../entities/token-session.entity");
const base_enum_1 = require("../enums/base.enum");
const base_service_1 = require("./base.service");
let TokenService = class TokenService {
    constructor(jwtService) {
        this.jwtService = jwtService;
    }
    async generateToken(payload, options) {
        const token = await this.jwtService.signAsync(payload, {
            secret: environment_service_1.evt.JWT_SECRET || 'JWT_SECRET',
            ...options,
        });
        // this.
        return { token };
    }
    async decryptToken(token, options) {
        try {
            return await this.jwtService.verifyAsync(token, {
                secret: environment_service_1.evt.JWT_SECRET,
                ...options,
            });
        }
        catch (error) {
            utility_service_1.UtilityClass.throwError({
                error,
                message: 'Token error',
                statusCode: 400,
            });
        }
    }
};
exports.TokenService = TokenService;
exports.TokenService = TokenService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [jwt_1.JwtService])
], TokenService);
let TokenSessionService = class TokenSessionService extends base_service_1.BaseService {
    constructor(repo) {
        super(repo, base_enum_1.ETableName.tokenSession);
        this.repo = repo;
    }
    _create(data) {
        return super._create(data);
    }
    async drop(param) {
        if (param.id)
            return this._updateByID(param.id, { ...param, active: false });
        else if (param.token)
            return this.repo.update({ token: param.token }, { ...param, active: false });
        else if (param.ownerID)
            return Promise.all((await this.getAllIDs({ ownerID: param.ownerID })).map((id) => this.repo.update({ id }, { ...param, active: false })));
    }
};
exports.TokenSessionService = TokenSessionService;
exports.TokenSessionService = TokenSessionService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(token_session_entity_1.TokenSessionEntity)),
    __metadata("design:paramtypes", [typeorm_2.Repository])
], TokenSessionService);
let TokenServiceModule = class TokenServiceModule {
};
exports.TokenServiceModule = TokenServiceModule;
exports.TokenServiceModule = TokenServiceModule = __decorate([
    (0, common_1.Global)(),
    (0, common_1.Module)({
        imports: [typeorm_1.TypeOrmModule.forFeature([token_session_entity_1.TokenSessionEntity])],
        providers: [TokenService, TokenSessionService],
        exports: [TokenService, TokenSessionService],
    })
], TokenServiceModule);
//# sourceMappingURL=token.service.js.map