"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BulkSMSNGService = void 0;
const axios_1 = require("axios");
const sms_enum_1 = require("../../enums/sms.enum");
const environment_service_1 = require("../environment.service");
const sms_sp_class_1 = require("./sms-sp.class");
const index_config_1 = require("../../configs/index.config");
const baseAPI = `https://www.bulksmsnigeria.com/api/v2/`;
exports.BulkSMSNGService = new sms_sp_class_1.SMSSPBase({
    providerKey: sms_enum_1.ESMSProvider.bulkSMSNG,
    sendFunc: async (data) => {
        if (!environment_service_1.evt.BULKSMSNGAPIKEY)
            throw `API key 'BULKSMSNGAPIKEY' not found`;
        const send = await axios_1.default
            .post(`${baseAPI}sms`, {
            body: data.message,
            from: index_config_1.SDKConfig.SMSsenderID,
            to: data.recipient,
            api_token: environment_service_1.evt.BULKSMSNGAPIKEY,
            gateway: 'direct-refund',
        })
            .then((r) => r.data);
        // if (data.onDelivered) {
        //   const { data: deliveryReport } = await axios.get(`${baseAPI}delivery`);
        // }
        return { delivered: false, success: true, response: send };
    },
});
//# sourceMappingURL=bulk-sms-nigeria.service.js.map