import { FindOptionsWhere, Repository } from 'typeorm';
import { ICheckByParams } from '../interfaces/base.interface';
import { ToggleActiveDTO } from '../dtos/base.dto';
import { BaseEntity } from '../entities/base.entity';
import { SearchQueryDto } from '../dtos/search.dto';
import { IAuthParam } from '../modules/authentication/authentication.interface';
import { ISearchQueryItem } from '../interfaces/search.interface';
export declare class SharedRepositoryService<TEntity extends BaseEntity, TSearchDto extends SearchQueryDto = SearchQueryDto> {
    checkIfExistsById(repo: Repository<TEntity | BaseEntity>, id: string, config?: Pick<ICheckByParams<TEntity>['config'], 'throwError' | 'errorMessage'>): Promise<boolean>;
    checkIfExistsBy(repo: Repository<TEntity | BaseEntity>, where: ICheckByParams<TEntity>['where'], config?: Omit<ICheckByParams<TEntity>['config'], 'shouldExist'>): Promise<boolean>;
    checkIfUniqueById(repo: Repository<TEntity | BaseEntity>, id: string, config?: Pick<ICheckByParams<TEntity>['config'], 'throwError' | 'errorMessage'>): Promise<boolean>;
    checkIfUniqueBy(repo: Repository<TEntity | BaseEntity>, where: ICheckByParams<TEntity>['where'], config?: Omit<ICheckByParams<TEntity>['config'], 'shouldExist'>): Promise<boolean>;
    checkExistenceBy(repo: Repository<TEntity | BaseEntity>, where: FindOptionsWhere<TEntity> | FindOptionsWhere<TEntity>[], config: ICheckByParams<TEntity>['config']): Promise<boolean>;
    getAllIDs(repo: Repository<TEntity | BaseEntity>, where?: FindOptionsWhere<TEntity> | FindOptionsWhere<TEntity>[]): Promise<string[]>;
    toggleActive(repo: Repository<TEntity | BaseEntity>, id: string, body: ToggleActiveDTO): Promise<boolean>;
    search(repo: Repository<TEntity | BaseEntity>, tableName: string, queryStruct: ISearchQueryItem<TSearchDto>[], query: TSearchDto, auth?: IAuthParam): Promise<import("../interfaces/search.interface").ISearchResponse<TEntity>>;
}
