"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.loggerFactory = exports.logger$ = exports.initLogger = exports.logger = exports.stream = void 0;
const fs = require("fs");
const path = require("path");
const rxjs_1 = require("rxjs");
const winston = require("winston");
const winstonDaily = require("winston-daily-rotate-file");
let _logger;
// debugger;
// logs dir
const sharedTransConfig = (logDir, level) => ({
    level,
    datePattern: 'YYYY-MM-DD',
    dirname: `${logDir}/${level}`, // log file /logs/debug/*.log in save
    filename: `%DATE%.log`,
    maxFiles: 30, // 30 Days saved
    json: false,
    zippedArchive: true,
});
const initLogger = (logDir = path.join(__dirname, '../logs')) => {
    if (!fs.existsSync(logDir)) {
        fs.mkdirSync(logDir);
    }
    // Define log format
    const logFormat = winston.format.printf(({ timestamp, level, message }) => {
        return `${timestamp} ${level}: ${message}`;
    });
    /*
     * Log Level
     * error: 0, warn: 1, info: 2, http: 3, verbose: 4, debug: 5, silly: 6
     */
    _logger = winston.createLogger({
        format: winston.format.combine(winston.format.timestamp({
            format: 'YYYY-MM-DD HH:mm:ss',
        }), logFormat),
        transports: [
            // debug log setting
            new winstonDaily(sharedTransConfig(logDir, 'debug')),
            // error log setting
            new winstonDaily(sharedTransConfig(logDir, 'error')),
        ],
    });
    _logger.add(new winston.transports.Console({
        format: winston.format.combine(winston.format.splat(), winston.format.colorize()),
    }));
};
exports.initLogger = initLogger;
const stream = {
    write: (message) => {
        _logger.info(message.substring(0, message.lastIndexOf('\n')));
    },
};
exports.stream = stream;
const _logFunc = (level) => (val, title, ...meta) => {
    const message = JSON.stringify({ log: val, meta });
    logger$.next({
        message: typeof val == 'string' ? val : JSON.stringify(val),
        title,
        isError: level == 'error',
    });
    return _logger[level](message);
};
const _logFuncNoTitle = (level, title) => (val, ...meta) => _logFunc(level)(val, title, meta);
const logger = {
    info: _logFunc('info'),
    log: _logFunc('info'),
    error: _logFunc('error'),
};
exports.logger = logger;
const logger$ = new rxjs_1.Subject();
exports.logger$ = logger$;
const loggerFactory = (subject) => ({
    info: _logFuncNoTitle('info', subject),
    log: _logFuncNoTitle('info', subject),
    error: _logFuncNoTitle('error', subject),
});
exports.loggerFactory = loggerFactory;
//# sourceMappingURL=logger.service.js.map