import { Subject } from 'rxjs';
declare const initLogger: (logDir?: string) => void;
declare const stream: {
    write: (message: string) => void;
};
declare const logger: {
    info: (val: unknown, title?: string, ...meta: any[]) => any;
    log: (val: unknown, title?: string, ...meta: any[]) => any;
    error: (val: unknown, title?: string, ...meta: any[]) => any;
};
declare const logger$: Subject<{
    isError?: boolean;
    message: string;
    title?: string;
}>;
declare const loggerFactory: (subject: string) => {
    info: (val: unknown, ...meta: any[]) => any;
    log: (val: unknown, ...meta: any[]) => any;
    error: (val: unknown, ...meta: any[]) => any;
};
export { stream, logger, initLogger, logger$, loggerFactory };
