"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LoggerService = void 0;
const common_1 = require("@nestjs/common");
const fs = require("fs");
const path = require("path");
const winston = require("winston");
const winstonDaily = require("winston-daily-rotate-file");
let LoggerService = class LoggerService {
    constructor() {
        this.initLogger = (logDir = path.join(__dirname, '../logs')) => {
            if (!fs.existsSync(logDir)) {
                fs.mkdirSync(logDir);
            }
            // Define log format
            const logFormat = winston.format.printf(({ timestamp, level, message }) => `${timestamp} ${level}: ${message}`);
            /*
             * Log Level
             * error: 0, warn: 1, info: 2, http: 3, verbose: 4, debug: 5, silly: 6
             */
            this._logger = winston.createLogger({
                format: winston.format.combine(winston.format.timestamp({
                    format: 'YYYY-MM-DD HH:mm:ss',
                }), logFormat),
                transports: [
                    // debug log setting
                    new winstonDaily({
                        level: 'debug',
                        datePattern: 'YYYY-MM-DD',
                        dirname: logDir + '/debug', // log file /logs/debug/*.log in save
                        filename: `%DATE%.log`,
                        maxFiles: 30, // 30 Days saved
                        json: true,
                        zippedArchive: true,
                    }),
                    // error log setting
                    new winstonDaily({
                        level: 'error',
                        datePattern: 'YYYY-MM-DD',
                        dirname: logDir + '/error', // log file /logs/error/*.log in save
                        filename: `%DATE%.log`,
                        maxFiles: 30, // 30 Days saved
                        handleExceptions: true,
                        json: true,
                        zippedArchive: true,
                    }),
                ],
            });
            this._logger.add(new winston.transports.Console({
                format: winston.format.combine(winston.format.splat(), winston.format.colorize()),
            }));
        };
    }
    write(message) {
        this._logger.info(message.substring(0, message.lastIndexOf('\n')));
    }
    info(val, ...meta) {
        this._logger.info(JSON.stringify({ val, meta }));
    }
    error(val, ...meta) {
        this._logger.error(JSON.stringify({ val, meta }));
    }
};
exports.LoggerService = LoggerService;
exports.LoggerService = LoggerService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [])
], LoggerService);
//# sourceMappingURL=logger.di.service.js.map