"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LikesService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("typeorm");
const typeorm_2 = require("@nestjs/typeorm");
const likes_entity_1 = require("../entities/likes.entity");
let LikesService = class LikesService {
    constructor(likesRepository) {
        this.likesRepository = likesRepository;
    }
    async likeDislikeFile(params, isLike) {
        if (isLike === null) {
            this.likesRepository.delete({
                refID: params.refID,
            });
        }
        else {
            const existingLikes = await this.likesRepository.find({
                where: { creatorId: params.createdBy, refCat: params.refCat },
            });
            if (existingLikes.length === 0)
                await this.likesRepository.save({ ...params, liked: isLike });
            else {
                const latestFound = existingLikes
                    .sort((a, b) => a.createdAt.localeCompare(b.createdAt))
                    .pop();
                if (existingLikes.length > 0)
                    Promise.all(existingLikes.map((x) => this.likesRepository.delete({ id: x.id })));
                if (latestFound.liked != isLike)
                    await this.likesRepository.update({ id: latestFound.id }, { liked: isLike });
            }
        }
        return await this.calculateLikesDislikes(params.refID);
    }
    async likeFile(params) {
        return this.likeDislikeFile(params, true);
    }
    async dislikeFile(params) {
        return this.likeDislikeFile(params, false);
    }
    async unlikeFile(params) {
        return this.likeDislikeFile(params, null);
    }
    async calculateLikesDislikes(refID) {
        const [likes, dislikes] = await Promise.all([
            this.likesRepository.count({
                where: { refID, liked: true },
            }),
            this.likesRepository.count({
                where: { refID, liked: false },
            }),
        ]);
        return { likes, dislikes };
    }
};
exports.LikesService = LikesService;
exports.LikesService = LikesService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_2.InjectRepository)(likes_entity_1.LikesEntity)),
    __metadata("design:paramtypes", [typeorm_1.Repository])
], LikesService);
//# sourceMappingURL=likes.service.js.map