import { Repository } from 'typeorm';
import { ERefCat } from '../enums/base.enum';
import { LikesEntity } from '../entities/likes.entity';
export declare class LikesService {
    protected readonly likesRepository: Repository<LikesEntity>;
    constructor(likesRepository: Repository<LikesEntity>);
    protected likeDislikeFile(params: Action, isLike: boolean | null): Promise<{
        likes: number;
        dislikes: number;
    }>;
    likeFile(params: Action): Promise<{
        likes: number;
        dislikes: number;
    }>;
    dislikeFile(params: Action): Promise<{
        likes: number;
        dislikes: number;
    }>;
    unlikeFile(params: Action): Promise<{
        likes: number;
        dislikes: number;
    }>;
    calculateLikesDislikes(refID: string): Promise<{
        likes: number;
        dislikes: number;
    }>;
}
type Action = {
    refID: string;
    createdBy: string;
    refCat: ERefCat;
};
export {};
