import { FileActionDto, FileSearchDto, FileToken, FileUpdateDto, FileUploadDto, FileUploadJSONDto, GetFileByRefDto } from '../dtos/file.dto';
import { FileContentEntity, FileEntity } from '../entities/file.entity';
import { Repository } from 'typeorm';
import { IFileDownloadResponse, IFileID } from '../interfaces/file.interface';
import { LikesService } from './likes.service';
import { BatchDeleteDto, IDDto } from '../dtos/base.dto';
import { IToken } from '../interfaces/base.interface';
import { TokenService } from './token.service';
import { RoutePath } from '../classes/route-path.class';
import { Subject } from 'rxjs';
export declare const FileRoutePath: RoutePath;
export declare class FileService {
    readonly fileRepository: Repository<FileEntity>;
    readonly fileContentRepository: Repository<FileContentEntity>;
    protected readonly likesService: LikesService;
    protected readonly tokenService: TokenService;
    routePath: RoutePath;
    readonly maxUploadSize: number;
    readonly filesToRegenerate: Map<string, FileEntity>;
    readonly regenerationTrigger$: Subject<FileEntity>;
    constructor(fileRepository: Repository<FileEntity>, fileContentRepository: Repository<FileContentEntity>, likesService: LikesService, tokenService: TokenService);
    static downloadPathGenerator: (fileID: string) => string;
    static downloadPathGeneratorWithToken: (token: string) => string;
    upload(multerFile: Express.Multer.File, meta: FileUploadDto): Promise<FileEntity>;
    protected _upload(file: {
        dataURI?: string;
        mimetype?: string;
        path?: string;
        fileExtension: string;
        saveContentToDB?: boolean;
        /**Bytes */
        fileSize: number;
    }, meta: FileUpdateDto): Promise<FileEntity>;
    uploadJSON({ fileExtension, dataURI, ...meta }: FileUploadJSONDto): Promise<FileEntity>;
    b64toBlob: (b64Data: string, contentType?: string, sliceSize?: number) => Blob;
    base64ToArrayBuffer(base64: string): ArrayBuffer;
    updateFile(body: FileUpdateDto & IFileID): Promise<void>;
    likeFile(params: FileActionDto): Promise<FileEntity>;
    dislikeFile(params: FileActionDto): Promise<FileEntity>;
    unlikeFile(params: FileActionDto): Promise<FileEntity>;
    updateLikesDislikes(albumID: string, data?: {
        likes: number;
        dislikes: number;
    }): Promise<FileEntity>;
    deleteSingleFile(params: IFileID): Promise<import("typeorm").UpdateResult>;
    deleteFileBatch(params: BatchDeleteDto): Promise<import("typeorm").UpdateResult>;
    restoreFileSingle(params: IFileID): Promise<FileEntity>;
    restoreFileBatch(params: BatchDeleteDto): Promise<import("typeorm").UpdateResult>;
    getFileByID(fileID: string): Promise<FileEntity>;
    checkIfFileExists(fileID: string): Promise<boolean>;
    search(query: FileSearchDto): Promise<import("..").ISearchResponse<FileEntity>>;
    getFileForPublic(query: GetFileByRefDto | IDDto): Promise<FileEntity>;
    regenerateAllLinks(): Promise<string>;
    generateFileLink(fileToken: FileEntity): Promise<string>;
    generateFileLink(fileId: string): Promise<string>;
    protected tokenizeFile(params: FileToken): Promise<string>;
    getFilePath(fileToken: FileToken): Promise<IFileDownloadResponse>;
    getFilePath(fileId: IFileID): Promise<IFileDownloadResponse>;
    getFilePathWithToken(params: IToken): Promise<IFileDownloadResponse>;
    /**
     * Format bytes as human-readable text.
     *
     * @param bytes Number of bytes.
     * @param si True to use metric (SI) units, aka powers of 1000. False to use
     *           binary (IEC), aka powers of 1024.
     * @param dp Number of decimal places to display.
     *
     * @return Formatted string.
     */
    formatFileSize(bytes: number, si?: boolean, dp?: number): string;
}
