"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SDKEnvironmentService = exports.evt = exports.ISDKEnvironment = void 0;
exports.setSDKEnvironment = setSDKEnvironment;
const common_1 = require("@nestjs/common");
const config_1 = require("@nestjs/config");
const multer = require("multer");
const path = require("path");
class ISDKEnvironment {
    constructor() {
        this.SERVER_PORT = null;
        this.SERVER_HOST = null;
        /**Don't set in env file */
        this.SERVER_URL = null;
        this.DATABASE_TYPE = null;
        this.DATABASE_HOST = null;
        this.DATABASE_PORT = null;
        this.DATABASE_USERNAME = null;
        this.DATABASE_PASSWORD = null;
        this.DATABASE_NAME = null;
        this.ENVIRONMENT = 'dev';
        this.MULTER_DEST = './uploads';
        this.JWT_SECRET = null;
        this.SYSTEM_EMAIL_ADDRESS = null;
        this.SYSTEM_EMAIL_PASSWORD = null;
        this.BULKSMSNGAPIKEY = null;
        this.SMTP_HOST = null;
        this.SMTP_PORT = null;
        this.DB_TIMEZONE_OFFSET = 0;
        this.SYNCHRONIZE = null;
    }
    get isProduction() {
        return this.ENVIRONMENT == 'production';
    }
    get isDev() {
        return this.ENVIRONMENT == 'dev';
    }
    get isStaging() {
        return this.ENVIRONMENT == 'staging';
    }
    reinit(val) {
        Object.assign(this, val);
    }
}
exports.ISDKEnvironment = ISDKEnvironment;
exports.evt = new ISDKEnvironment();
let SDKEnvironmentService = class SDKEnvironmentService {
    constructor(configService) {
        this.configService = configService;
        this.extractEnvironmentData(this.evt);
        // console.log('called');
        // debugger;
    }
    get evt() {
        return exports.evt;
    }
    createJwtOptions() {
        return {
            global: true,
            secret: this.evt.JWT_SECRET,
            signOptions: { expiresIn: '24h' },
        };
    }
    createTypeOrmOptions() {
        return {
            type: this.evt.DATABASE_TYPE,
            host: this.evt.DATABASE_HOST,
            port: this.evt.DATABASE_PORT,
            username: this.evt.DATABASE_USERNAME,
            password: this.evt.DATABASE_PASSWORD,
            database: this.evt.DATABASE_NAME,
            synchronize: this.evt.ENVIRONMENT == 'dev',
            entities: this.entities,
        };
    }
    extractEnvironmentData(_evt) {
        for (const key in _evt) {
            if (Object.prototype.hasOwnProperty.call(_evt, key)) {
                let v = this.configService.get(key, {
                    infer: true,
                });
                if (v == 'true')
                    v = true;
                else if (v == 'false')
                    v = false;
                exports.evt[key] = _evt[key] = v == null ? exports.evt[key] : v;
            }
        }
    }
    createMulterOptions() {
        // debugger;
        const dest = path.resolve(__dirname, exports.evt?.MULTER_DEST || './uploads');
        return {
            // dest,
            storage: multer.diskStorage({
                destination: dest,
                filename: (req, file, cb) => cb(null, `${req.body.refCat}-${req.body.refNo}.${file.originalname.split('.').slice(-1)[0]}`),
            }),
        };
    }
};
exports.SDKEnvironmentService = SDKEnvironmentService;
exports.SDKEnvironmentService = SDKEnvironmentService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [config_1.ConfigService])
], SDKEnvironmentService);
function setSDKEnvironment(val) {
    for (const key in val) {
        if (Object.prototype.hasOwnProperty.call(val, key)) {
            exports.evt[key] = val[key];
        }
    }
}
//# sourceMappingURL=environment.service.js.map