import { ConfigService } from '@nestjs/config';
import { JwtModuleOptions, JwtOptionsFactory } from '@nestjs/jwt';
import { MulterModuleOptions, MulterOptionsFactory } from '@nestjs/platform-express';
import { TypeOrmModuleOptions, TypeOrmOptionsFactory } from '@nestjs/typeorm';
import { DatabaseType, EntitySchema, MixedList } from 'typeorm';
export declare class ISDKEnvironment {
    SERVER_PORT: number;
    SERVER_HOST: string;
    /**Don't set in env file */
    SERVER_URL: string;
    DATABASE_TYPE: DatabaseType;
    DATABASE_HOST: string;
    DATABASE_PORT: number;
    DATABASE_USERNAME: string;
    DATABASE_PASSWORD: string;
    DATABASE_NAME: string;
    ENVIRONMENT: 'dev' | 'staging' | 'production';
    MULTER_DEST: string;
    JWT_SECRET: string;
    SYSTEM_EMAIL_ADDRESS?: string;
    SYSTEM_EMAIL_PASSWORD?: string;
    BULKSMSNGAPIKEY?: string;
    SMTP_HOST?: string;
    SMTP_PORT?: number;
    DB_TIMEZONE_OFFSET?: number;
    SYNCHRONIZE?: boolean;
    get isProduction(): boolean;
    get isDev(): boolean;
    get isStaging(): boolean;
    reinit(val: ISDKEnvironment): void;
}
export declare const evt: ISDKEnvironment;
export declare class SDKEnvironmentService implements TypeOrmOptionsFactory, MulterOptionsFactory, JwtOptionsFactory {
    protected configService: ConfigService<ISDKEnvironment>;
    entities: MixedList<Function | string | EntitySchema>;
    constructor(configService: ConfigService<ISDKEnvironment>);
    get evt(): ISDKEnvironment;
    createJwtOptions(): JwtModuleOptions | Promise<JwtModuleOptions>;
    createTypeOrmOptions(): TypeOrmModuleOptions;
    extractEnvironmentData(_evt: ISDKEnvironment): void;
    createMulterOptions(): MulterModuleOptions;
}
export declare function setSDKEnvironment(val: ISDKEnvironment): void;
