import { FindOptionsRelations, FindOptionsSelect, FindOptionsWhere, Repository } from 'typeorm';
import { SearchQueryDto } from '../dtos/search.dto';
import { ISearchQueryItem, ISearchResponse } from '../interfaces/search.interface';
import { EDeletionType, ETableName } from '../enums/base.enum';
import { BaseEntity } from '../entities/base.entity';
import { Chart, ChartItem, ChartQueryDto } from '../dtos/analytics.dto';
import { PickKeysByType } from 'typeorm/common/PickKeysByType';
import { ToggleActiveDTO, ToggleBulkActiveDTO, SetOrderDTO } from '../dtos/base.dto';
import { IAuthParam } from '../modules/authentication/authentication.interface';
import { SharedRepositoryService } from './shared-repository.service';
import { IControllerBlock, ICreateConfig } from '../interfaces/index.interface';
export declare class SDKBaseService<TEntity extends BaseEntity, TSearchDto extends SearchQueryDto = SearchQueryDto> {
    protected readonly repo: Repository<BaseEntity>;
    tableName: string;
    protected sharedRepositoryService: SharedRepositoryService<TEntity, TSearchDto>;
    protected _queryStruct: ISearchQueryItem<TSearchDto>[];
    get queryStruct(): ISearchQueryItem<TSearchDto>[];
    set queryStruct(value: ISearchQueryItem<TSearchDto>[]);
    static path: string;
    static get tag(): string;
    protected deletionStyle: EDeletionType;
    protected _blockController: IControllerBlock;
    protected baseRelations: FindOptionsRelations<TEntity>;
    protected baseSelect: FindOptionsSelect<TEntity>;
    constructor(repo: Repository<BaseEntity>, tableName: string);
    /**
     * @param data ```true``` indicates that the action should be blocked from the controller
     */
    updateControllerBlock(data: Partial<IControllerBlock>): void;
    get blockController(): {
        create?: boolean;
        read?: boolean;
        update?: boolean;
        delete?: boolean;
        restore?: boolean;
        toggle?: boolean;
        arrange?: boolean;
    };
    get isHardDeletion(): boolean;
    getById(id: string, auth?: IAuthParam): Promise<TEntity>;
    getSingle(where: FindOptionsWhere<TEntity>, auth?: IAuthParam): Promise<TEntity>;
    getWhere(where: FindOptionsWhere<TEntity> | FindOptionsWhere<TEntity>[]): Promise<TEntity[]>;
    checkIfExistsById(id: string, config?: Pick<ICheckByParams<TEntity>['config'], 'throwError' | 'errorMessage'>): Promise<boolean>;
    checkIfExistsBy(where: ICheckByParams<TEntity>['where'], config?: Omit<ICheckByParams<TEntity>['config'], 'shouldExist'>): Promise<boolean>;
    checkIfUniqueById(id: string, config?: Pick<ICheckByParams<TEntity>['config'], 'throwError' | 'errorMessage'>): Promise<boolean>;
    checkIfUniqueBy(where: ICheckByParams<TEntity>['where'], config?: Omit<ICheckByParams<TEntity>['config'], 'shouldExist'>): Promise<boolean>;
    checkExistenceBy(where: ICheckByParams<TEntity>['where'], config: ICheckByParams<TEntity>['config']): Promise<boolean>;
    checkIfDeletable(where: FindOptionsWhere<TEntity> | FindOptionsWhere<TEntity>[], config: {
        relationField: keyof TEntity;
        errorMessage?: string;
    }): Promise<boolean>;
    checkIfDeletable(checkFactory: () => Promise<boolean>, config: {
        errorMessage: string;
    }): Promise<boolean>;
    protected whereWrapper<TTEntity = TEntity>(where: FindOptionsWhere<TTEntity> | FindOptionsWhere<TTEntity>[]): FindOptionsWhere<TTEntity>;
    find(where?: FindOptionsWhere<TEntity> | FindOptionsWhere<TEntity>[]): Promise<TEntity[]>;
    getAllIDs(where?: FindOptionsWhere<TEntity> | FindOptionsWhere<TEntity>[]): Promise<string[]>;
    findOne(data: FindOptionsWhere<TEntity> | FindOptionsWhere<TEntity>[]): Promise<TEntity>;
    _updateChecks(id: string, data: any): Promise<void>;
    /**
     * Set the implementation of the pre update step. It is invoked immediately before update.
     * @returns
     */
    protected _preUpdateFunction(id: string, data: Partial<TEntity>): Promise<void>;
    /**
     * Set the implementation of the post update step. It is invoked after update.
     * @returns
     */
    protected _postUpdateFunction(id: string, data: Partial<TEntity>): Promise<void>;
    /**
     * Set the implementation of the update step only.
     * @returns
     */
    protected _updateFunction(id: string, data: Partial<TEntity>, config?: ICreateConfig): Promise<void>;
    _updateByID(id: string, data: Partial<TEntity>, config?: ICreateConfig): Promise<TEntity>;
    /**
     * Set the implementation of the pre deletion step. It is invoked before deletion.
     * @param ids array of id strings
     * @returns
     */
    protected _preDeletionFunction(ids: string[]): Promise<void>;
    /**
     * Set the implementation of the post deletion step. It is invoked after deletion.
     * @param ids array of id strings
     * @returns
     */
    protected _postDeletionFunction(ids: string[]): Promise<void>;
    /**
     * Set the implementation of only the deletion step. Checks should be handled elsewhere
     * @param ids array of id strings
     * @returns
     */
    protected _deletionFunction(ids: string[]): Promise<import("typeorm").DeleteResult>;
    /**
     * Delete a record by id. It contains checks and pre/post steps also.
     * @param id
     * @returns
     */
    _deleteByID(id: string, auth: IAuthParam): Promise<import("typeorm").DeleteResult>;
    /**
     * Delete multiple records by ids. It contains checks and pre/post steps also.
     * @param ids
     * @returns
     */
    _deleteByIDs(ids: string[], auth: IAuthParam): Promise<import("typeorm").DeleteResult>;
    /**
     * Delete multiple records. It contains checks and pre/post steps also.
     * @returns
     */
    _deleteBy(where: FindOptionsWhere<TEntity> | FindOptionsWhere<TEntity>[], auth: IAuthParam): Promise<import("typeorm").DeleteResult>;
    _deleteChecks(ids: string[], auth: IAuthParam): Promise<void>;
    /**
     * Set the implementation of only the restoration step. Checks should be handled elsewhere
     * @param ids array of id strings
     * @returns
     */
    protected _deletionRestorationFunction(ids: string[]): Promise<import("typeorm").UpdateResult>;
    /**
     * Set the implementation of the pre restoration step. It is invoked before restoration
     * @param ids array of id strings
     * @returns
     */
    protected _preRestorationFunction(ids: string[]): Promise<void>;
    /**
     * Set the implementation of the post restoration step. It is invoked after restoration
     * @param ids array of id strings
     * @returns
     */
    protected _postRestorationFunction(ids: string[]): Promise<void>;
    /**
     * Call this if your class uses a soft deletion technique. It restores a deleted record by id. It contains checks and pre/post steps also.
     * @param id
     * @returns
     */
    _restoreByID(id: string): Promise<import("typeorm").UpdateResult>;
    /**
     * Call this if your class uses a soft deletion technique. It restores deleted records by their ids. It contains checks and pre/post steps also.
     * @param ids array of id strings
     * @returns
     */
    _restoreByIDs(ids: string[]): Promise<import("typeorm").UpdateResult>;
    /**
     * Restore multiple records. It contains checks and pre/post steps also.
     * @returns
     */
    _restoreBy(where: FindOptionsWhere<TEntity> | FindOptionsWhere<TEntity>[]): Promise<import("typeorm").UpdateResult>;
    formatSearchQuery: (query: TSearchDto, auth?: IAuthParam) => Promise<TSearchDto>;
    formatSearchResults: (results: ISearchResponse<TEntity>, auth?: IAuthParam) => Promise<ISearchResponse<TEntity>>;
    search(query: TSearchDto, auth?: IAuthParam): Promise<ISearchResponse<TEntity>>;
    protected _save(data: Partial<TEntity>, config: ICreateConfig): Promise<TEntity>;
    _createChecks(data: any): Promise<void>;
    /**
     * Set the implementation of the pre create step. It is invoked immediately before creation.
     * @returns
     */
    protected _preCreateFunction(data: Partial<TEntity>): Promise<void>;
    /**
     * Set the implementation of the post create step. It is invoked after creation.
     * @returns
     */
    protected _postCreateFunction(requestData: Partial<TEntity>, savedData: TEntity): Promise<void>;
    /**
     * Set the implementation of the create step only.
     * @returns
     */
    protected _createFunction(requestData: Partial<TEntity>, config?: ICreateConfig): Promise<TEntity>;
    _create(data: Partial<TEntity>, config?: ICreateConfig): Promise<TEntity>;
    count(where?: FindOptionsWhere<TEntity> | FindOptionsWhere<TEntity>[]): Promise<number>;
    getAnalytics(params?: ChartQueryDto): Promise<Chart[]>;
    protected countExtractor<TTEntity = TEntity>(column: keyof TTEntity, repository?: Repository<TTEntity>): Promise<ChartItem[]>;
    protected countExtractor<TTEntity extends BaseEntity = TEntity>(queries: {
        label: string;
        where: FindOptionsWhere<TEntity | BaseEntity>[] | FindOptionsWhere<TEntity | BaseEntity>;
    }[], repository?: Repository<TTEntity>): Promise<ChartItem[]>;
    protected sumExtractor<TTEntity = TEntity>(queries: {
        label: string;
        column: PickKeysByType<TTEntity, number>;
        where: FindOptionsWhere<TTEntity>[] | FindOptionsWhere<TTEntity>;
    }[]): Promise<ChartItem[]>;
    toggleActive(id: string, body: ToggleActiveDTO): Promise<ToggleActiveDTO>;
    toggleBulkActive({ ids, ...body }: ToggleBulkActiveDTO): Promise<{
        rows: number;
    }>;
    toggleAllActive(body: ToggleActiveDTO): Promise<{
        rows: number;
    }>;
    arrangeItems(body: SetOrderDTO): Promise<boolean>;
}
export declare class BaseService<TEntity extends BaseEntity, TSearchDto extends SearchQueryDto = SearchQueryDto> extends SDKBaseService<TEntity, TSearchDto> {
    protected readonly repo: Repository<BaseEntity>;
    tableName: ETableName;
    constructor(repo: Repository<BaseEntity>, tableName: ETableName);
}
interface ICheckByParams<TEntity> {
    where: FindOptionsWhere<TEntity> | FindOptionsWhere<TEntity>[];
    config: {
        shouldExist: boolean;
        errorMessage?: string;
        throwError?: boolean;
    };
}
export {};
