import { HttpService } from '@nestjs/axios';
import { AxiosRequestConfig, AxiosResponse } from 'axios';
export declare class APIService {
    protected readonly httpService: HttpService;
    verbose: boolean;
    constructor(httpService: HttpService);
    get<T = any>(route: string, queryParams?: object, extras?: {
        axiosConfig: AxiosRequestConfig;
    }): Promise<T>;
    post<T = any>(route: string, body?: object, extras?: {
        axiosConfig: AxiosRequestConfig;
    }): Promise<T>;
    protected log(...items: any[]): void;
    protected handleResponse: <T>(res: AxiosResponse<T>) => T;
    protected handleError: (e: any) => never;
    formatURL(route: string, parameters?: object): string;
}
