import { Repository } from 'typeorm';
import { BaseService } from '../../services/base.service';
import { CreateWPSiteDTO, SearchWPSiteDTO, UpdateWPSiteDTO, WPCheckDomainDTO, WPItemQuery, WPListQuery } from './wordpress.dto';
import { WPSiteEntity } from './wordpress.entity';
import * as WPAPI from 'wpapi';
import { ToggleActiveDTO } from '../../dtos/base.dto';
import { WPPost, WPPostListQuery, WPPostSearchResponseDto } from './wordpress-post.dto';
import { WPPage, WPPageSearchResponseDto } from './wordpress-page.dto';
import { SearchResponseDto } from '../../dtos/search.dto';
import { WPCategory, WPCategorySearchResponseDto } from './wordpress-category.dto';
import { WPTag, WPTagSearchResponseDto } from './wordpress-tag.dto';
export declare class WordpressService extends BaseService<WPSiteEntity, SearchWPSiteDTO> {
    protected repo: Repository<WPSiteEntity>;
    static path: string;
    protected currentConfig: {
        currentSite: WPSiteEntity;
        currentWPAPI?: WPAPI;
    };
    protected tagSlugToIDMap: {
        [slug: string]: number;
    };
    protected categorySlugToIDMap: {
        [slug: string]: number;
    };
    constructor(repo: Repository<WPSiteEntity>);
    getWPAPI(): Promise<{
        currentSite: WPSiteEntity;
        currentWPAPI?: WPAPI;
    }>;
    resetWPAPI(): void;
    protected errorParser: <T>(e: Error) => T;
    checkDomain(query: WPCheckDomainDTO): Promise<{
        status: boolean;
        message: string;
    } | {
        status: boolean;
        message: any;
    }>;
    _createChecks(data: CreateWPSiteDTO): Promise<void>;
    toggleActive(id: string, body: ToggleActiveDTO): Promise<ToggleActiveDTO>;
    protected _postCreateFunction(requestData: Partial<WPSiteEntity>, savedData: WPSiteEntity): Promise<void>;
    protected _preCreateFunction(data: CreateWPSiteDTO): Promise<void>;
    protected _postUpdateFunction(id: string, data: UpdateWPSiteDTO): Promise<void>;
    _updateChecks(id: string, data: UpdateWPSiteDTO): Promise<void>;
    protected itemResponseWrapper<T, NT>(request: WPAPI.WPRequest, query: WPItemQuery, formatter?: (item: T) => NT): Promise<NT>;
    protected itemResponseWrapper<T>(request: WPAPI.WPRequest, query: WPItemQuery): Promise<T>;
    protected searchResponseWrapper<T, NT = any>(request: WPAPI.WPRequest, query: WPListQuery, formatter?: (item: T) => NT): Promise<SearchResponseDto<NT>>;
    protected searchResponseWrapper<T>(request: WPAPI.WPRequest, query: WPListQuery): Promise<SearchResponseDto<T>>;
    getPosts(query: WPPostListQuery): Promise<WPPostSearchResponseDto>;
    getPost(query: WPItemQuery): Promise<WPPost>;
    getPages(query: WPListQuery): Promise<WPPageSearchResponseDto>;
    getPage(query: WPItemQuery): Promise<WPPage>;
    getTags(query: WPListQuery): Promise<WPTagSearchResponseDto>;
    getTag(query: WPItemQuery): Promise<WPTag>;
    getCategories(query: WPListQuery): Promise<WPCategorySearchResponseDto>;
    getCategory(query: WPItemQuery): Promise<WPCategory>;
}
