"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WPContent = exports.WPLinks = exports.WPMeta = exports.WPLinkItem = exports.WPItemQuery = exports.WPListQuery = exports.WPCheckDomainDTO = exports.SearchWPSiteDTO = exports.UpdateWPSiteDTO = exports.CreateWPSiteDTO = void 0;
const class_validator_1 = require("class-validator");
const swagger_1 = require("@nestjs/swagger");
const search_dto_1 = require("../../dtos/search.dto");
const base_dto_1 = require("../../dtos/base.dto");
class CreateWPSiteDTO extends base_dto_1.BaseDto {
}
exports.CreateWPSiteDTO = CreateWPSiteDTO;
__decorate([
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], CreateWPSiteDTO.prototype, "name", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], CreateWPSiteDTO.prototype, "domain", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], CreateWPSiteDTO.prototype, "slug", void 0);
class UpdateWPSiteDTO extends (0, swagger_1.PartialType)(CreateWPSiteDTO) {
}
exports.UpdateWPSiteDTO = UpdateWPSiteDTO;
class SearchWPSiteDTO extends (0, swagger_1.IntersectionType)(search_dto_1.SearchQueryDto, UpdateWPSiteDTO) {
}
exports.SearchWPSiteDTO = SearchWPSiteDTO;
class WPCheckDomainDTO {
}
exports.WPCheckDomainDTO = WPCheckDomainDTO;
__decorate([
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], WPCheckDomainDTO.prototype, "domain", void 0);
class WPListQuery extends (0, swagger_1.PickType)(search_dto_1.SearchQueryDto, [
    'pageNumber',
    'pageSize',
    'sortDirection',
    'sortField',
    'createdFrom',
    'createdTo',
]) {
    constructor() {
        super(...arguments);
        this.pageNumber = 1;
        this.pageSize = 10;
    }
}
exports.WPListQuery = WPListQuery;
class WPItemQuery {
    constructor() {
        this.id = undefined;
        this.slug = undefined;
    }
}
exports.WPItemQuery = WPItemQuery;
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsNumberString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Number)
], WPItemQuery.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], WPItemQuery.prototype, "slug", void 0);
class WPLinkItem {
}
exports.WPLinkItem = WPLinkItem;
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    __metadata("design:type", String)
], WPLinkItem.prototype, "name", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], WPLinkItem.prototype, "href", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    __metadata("design:type", Boolean)
], WPLinkItem.prototype, "templated", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    __metadata("design:type", Number)
], WPLinkItem.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    __metadata("design:type", Number)
], WPLinkItem.prototype, "count", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    __metadata("design:type", Boolean)
], WPLinkItem.prototype, "embeddable", void 0);
class WPMeta {
}
exports.WPMeta = WPMeta;
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], WPMeta.prototype, "footnotes", void 0);
class WPLinks {
}
exports.WPLinks = WPLinks;
__decorate([
    (0, swagger_1.ApiProperty)({ type: [WPLinkItem] }),
    __metadata("design:type", Array)
], WPLinks.prototype, "self", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: [WPLinkItem] }),
    __metadata("design:type", Array)
], WPLinks.prototype, "collection", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: [WPLinkItem] }),
    __metadata("design:type", Array)
], WPLinks.prototype, "about", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: [WPLinkItem] }),
    __metadata("design:type", Array)
], WPLinks.prototype, "author", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: [WPLinkItem] }),
    __metadata("design:type", Array)
], WPLinks.prototype, "replies", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: [WPLinkItem] }),
    __metadata("design:type", Array)
], WPLinks.prototype, "version-history", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: [WPLinkItem] }),
    __metadata("design:type", Array)
], WPLinks.prototype, "predecessor-version", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: [WPLinkItem] }),
    __metadata("design:type", Array)
], WPLinks.prototype, "wp:attachment", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: [WPLinkItem] }),
    __metadata("design:type", Array)
], WPLinks.prototype, "curies", void 0);
class WPContent {
}
exports.WPContent = WPContent;
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], WPContent.prototype, "rendered", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    __metadata("design:type", Boolean)
], WPContent.prototype, "protected", void 0);
//# sourceMappingURL=wordpress.dto.js.map