"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WordpressController = exports.WordpressRoutePath = void 0;
const common_1 = require("@nestjs/common");
const base_controller_1 = require("../../controllers/base.controller");
const wordpress_dto_1 = require("./wordpress.dto");
const wordpress_service_1 = require("./wordpress.service");
const authentication_guard_1 = require("../authentication/authentication.guard");
const base_dto_1 = require("../../dtos/base.dto");
const swagger_1 = require("@nestjs/swagger");
const search_dto_1 = require("../../dtos/search.dto");
const utility_service_1 = require("../../services/utility.service");
const wordpress_post_dto_1 = require("./wordpress-post.dto");
const wordpress_page_dto_1 = require("./wordpress-page.dto");
const wordpress_category_dto_1 = require("./wordpress-category.dto");
const wordpress_tag_dto_1 = require("./wordpress-tag.dto");
const route_path_class_1 = require("../../classes/route-path.class");
exports.WordpressRoutePath = new route_path_class_1.RoutePath('wordpress');
let WordpressController = class WordpressController extends base_controller_1.BaseCRUDController {
    constructor(service) {
        super(service);
        this.service = service;
    }
    create(body, auth) {
        return super.create(body, auth);
    }
    updateByID(param, body, auth) {
        return super.updateByID(param, body, auth);
    }
    async search(query) {
        return super.search(query);
    }
    async checkDomain(query) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.checkDomain(query),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async getCategories(query) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.getCategories(query),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async getCategory(query) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.getCategory(query),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async getPosts(query) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.getPosts(query),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async getPost(query) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.getPost(query),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async getPages(query) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.getPages(query),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async getPage(query) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.getPage(query),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async getTags(query) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.getTags(query),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async getTag(query) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.getTag(query),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async getWPAPI() {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: { active: !!(await this.service.getWPAPI())?.currentSite },
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
};
exports.WordpressController = WordpressController;
__decorate([
    (0, swagger_1.ApiBearerAuth)(),
    (0, common_1.Post)(''),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, authentication_guard_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [wordpress_dto_1.CreateWPSiteDTO, Object]),
    __metadata("design:returntype", void 0)
], WordpressController.prototype, "create", null);
__decorate([
    (0, swagger_1.ApiBearerAuth)(),
    (0, common_1.Put)(':id'),
    __param(0, (0, common_1.Param)()),
    __param(1, (0, common_1.Body)()),
    __param(2, (0, authentication_guard_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [base_dto_1.IDDto,
        wordpress_dto_1.UpdateWPSiteDTO, Object]),
    __metadata("design:returntype", void 0)
], WordpressController.prototype, "updateByID", null);
__decorate([
    (0, common_1.Get)('search'),
    (0, swagger_1.ApiResponse)({ type: search_dto_1.SearchResponseDto }),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [wordpress_dto_1.SearchWPSiteDTO]),
    __metadata("design:returntype", Promise)
], WordpressController.prototype, "search", null);
__decorate([
    (0, common_1.Get)('check-domain'),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [wordpress_dto_1.WPCheckDomainDTO]),
    __metadata("design:returntype", Promise)
], WordpressController.prototype, "checkDomain", null);
__decorate([
    (0, authentication_guard_1.PublicAuth)(),
    (0, common_1.Get)('categories/search'),
    (0, swagger_1.ApiResponse)({ type: wordpress_category_dto_1.WPCategorySearchResponseDto }),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [wordpress_dto_1.WPListQuery]),
    __metadata("design:returntype", Promise)
], WordpressController.prototype, "getCategories", null);
__decorate([
    (0, authentication_guard_1.PublicAuth)(),
    (0, common_1.Get)('categories/single'),
    (0, swagger_1.ApiResponse)({ type: wordpress_category_dto_1.WPCategory }),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [wordpress_dto_1.WPItemQuery]),
    __metadata("design:returntype", Promise)
], WordpressController.prototype, "getCategory", null);
__decorate([
    (0, authentication_guard_1.PublicAuth)(),
    (0, common_1.Get)('posts/search'),
    (0, swagger_1.ApiResponse)({ type: wordpress_post_dto_1.WPPostSearchResponseDto }),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [wordpress_post_dto_1.WPPostListQuery]),
    __metadata("design:returntype", Promise)
], WordpressController.prototype, "getPosts", null);
__decorate([
    (0, authentication_guard_1.PublicAuth)(),
    (0, common_1.Get)('posts/single'),
    (0, swagger_1.ApiResponse)({ type: wordpress_post_dto_1.WPPost }),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [wordpress_dto_1.WPItemQuery]),
    __metadata("design:returntype", Promise)
], WordpressController.prototype, "getPost", null);
__decorate([
    (0, authentication_guard_1.PublicAuth)(),
    (0, common_1.Get)('pages/search'),
    (0, swagger_1.ApiResponse)({ type: wordpress_page_dto_1.WPPageSearchResponseDto }),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [wordpress_dto_1.WPListQuery]),
    __metadata("design:returntype", Promise)
], WordpressController.prototype, "getPages", null);
__decorate([
    (0, authentication_guard_1.PublicAuth)(),
    (0, common_1.Get)('pages/single'),
    (0, swagger_1.ApiResponse)({ type: wordpress_page_dto_1.WPPage }),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [wordpress_dto_1.WPItemQuery]),
    __metadata("design:returntype", Promise)
], WordpressController.prototype, "getPage", null);
__decorate([
    (0, authentication_guard_1.PublicAuth)(),
    (0, common_1.Get)('tags/search'),
    (0, swagger_1.ApiResponse)({ type: wordpress_tag_dto_1.WPTagSearchResponseDto }),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [wordpress_dto_1.WPListQuery]),
    __metadata("design:returntype", Promise)
], WordpressController.prototype, "getTags", null);
__decorate([
    (0, authentication_guard_1.PublicAuth)(),
    (0, common_1.Get)('tags/single'),
    (0, swagger_1.ApiResponse)({ type: wordpress_tag_dto_1.WPTag }),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [wordpress_dto_1.WPItemQuery]),
    __metadata("design:returntype", Promise)
], WordpressController.prototype, "getTag", null);
__decorate([
    (0, authentication_guard_1.PublicAuth)(),
    (0, common_1.Get)('active'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], WordpressController.prototype, "getWPAPI", null);
exports.WordpressController = WordpressController = __decorate([
    (0, swagger_1.ApiTags)(exports.WordpressRoutePath.tag),
    (0, common_1.Controller)(exports.WordpressRoutePath.path),
    __metadata("design:paramtypes", [wordpress_service_1.WordpressService])
], WordpressController);
//# sourceMappingURL=wordpress.controller.js.map