import { BaseEntity } from '../../entities/base.entity';
import { ECurrency, ETransMethod, ETransactionType } from './wallet.enum';
export declare class WalletEntity extends BaseEntity<WalletEntity> {
    name?: string;
    userID: string;
    type?: any;
    allowOverdraft: boolean;
    overdraftLimit: number;
    transactions?: WalletTransactionEntity[];
    walletExternalBanks?: WalletExternalBank[];
}
export declare class WalletExternalBank extends BaseEntity<WalletExternalBank> {
    code?: string;
    accountNumber?: string;
    bankName?: string;
    sortCode?: string;
    wallet: WalletEntity;
}
export declare class WalletTransactionEntity extends BaseEntity<WalletTransactionEntity> {
    amount: number;
    surcharge: number;
    netBalanceBefore: number;
    grossBalanceBefore: number;
    type: ETransactionType;
    currency: ECurrency;
    reason?: string;
    refCat?: string;
    redirectURL?: string;
    transMethod: ETransMethod;
    isVerified: boolean;
    isTemporary?: boolean;
    isFailed: boolean;
    isOverdraft?: boolean;
    transactionReference: string;
    userID?: string;
    wallet?: WalletEntity;
}
export declare class WalletBalanceView extends WalletEntity {
    grossBalance: number;
    netBalance: number;
    grossTotalCredit: number;
    grossTotalDebit: number;
    netTotalCredit: number;
    netTotalDebit: number;
}
export declare const WalletEntities: (typeof WalletEntity | typeof WalletTransactionEntity | typeof WalletExternalBank)[];
