"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WalletTransactionSearchDTO = exports.CreateWalletTransactionDTO = exports.UpdateWalletTransactionDTO = exports.WalletSearchDTO = exports.UpdateWalletDto = exports.CreateWalletDTO = void 0;
const swagger_1 = require("@nestjs/swagger");
const class_validator_1 = require("class-validator");
const search_dto_1 = require("../../dtos/search.dto");
const wallet_enum_1 = require("./wallet.enum");
const to_boolean_decorator_1 = require("../../decorators/to-boolean.decorator");
class CreateWalletDTO {
}
exports.CreateWalletDTO = CreateWalletDTO;
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], CreateWalletDTO.prototype, "name", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], CreateWalletDTO.prototype, "userID", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], CreateWalletDTO.prototype, "orgID", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ type: 'string' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Object)
], CreateWalletDTO.prototype, "type", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsBoolean)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Boolean)
], CreateWalletDTO.prototype, "allowOverdraft", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Number)
], CreateWalletDTO.prototype, "overdraftLimit", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsBoolean)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Boolean)
], CreateWalletDTO.prototype, "active", void 0);
class UpdateWalletDto extends (0, swagger_1.PartialType)(CreateWalletDTO) {
}
exports.UpdateWalletDto = UpdateWalletDto;
class WalletSearchDTO extends search_dto_1.SearchQueryDto {
}
exports.WalletSearchDTO = WalletSearchDTO;
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumberString)(),
    __metadata("design:type", Number)
], WalletSearchDTO.prototype, "grossBalance", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumberString)(),
    __metadata("design:type", Number)
], WalletSearchDTO.prototype, "grossBalanceFrom", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumberString)(),
    __metadata("design:type", Number)
], WalletSearchDTO.prototype, "grossBalanceTo", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumberString)(),
    __metadata("design:type", Number)
], WalletSearchDTO.prototype, "netBalance", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumberString)(),
    __metadata("design:type", Number)
], WalletSearchDTO.prototype, "netBalanceFrom", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumberString)(),
    __metadata("design:type", Number)
], WalletSearchDTO.prototype, "netBalanceTo", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumberString)(),
    __metadata("design:type", Number)
], WalletSearchDTO.prototype, "grossTotalCredit", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumberString)(),
    __metadata("design:type", Number)
], WalletSearchDTO.prototype, "grossTotalCreditFrom", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumberString)(),
    __metadata("design:type", Number)
], WalletSearchDTO.prototype, "grossTotalCreditTo", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumberString)(),
    __metadata("design:type", Number)
], WalletSearchDTO.prototype, "grossTotalDebit", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumberString)(),
    __metadata("design:type", Number)
], WalletSearchDTO.prototype, "grossTotalDebitFrom", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumberString)(),
    __metadata("design:type", Number)
], WalletSearchDTO.prototype, "grossTotalDebitTo", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumberString)(),
    __metadata("design:type", Number)
], WalletSearchDTO.prototype, "netTotalCredit", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumberString)(),
    __metadata("design:type", Number)
], WalletSearchDTO.prototype, "netTotalCreditFrom", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumberString)(),
    __metadata("design:type", Number)
], WalletSearchDTO.prototype, "netTotalCreditTo", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumberString)(),
    __metadata("design:type", Number)
], WalletSearchDTO.prototype, "netTotalDebit", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumberString)(),
    __metadata("design:type", Number)
], WalletSearchDTO.prototype, "netTotalDebitFrom", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumberString)(),
    __metadata("design:type", Number)
], WalletSearchDTO.prototype, "netTotalDebitTo", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ type: 'boolean' }),
    (0, class_validator_1.IsBooleanString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Boolean)
], WalletSearchDTO.prototype, "allowOverdraft", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumberString)(),
    __metadata("design:type", Number)
], WalletSearchDTO.prototype, "overdraftLimit", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumberString)(),
    __metadata("design:type", Number)
], WalletSearchDTO.prototype, "overdraftLimitFrom", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumberString)(),
    __metadata("design:type", Number)
], WalletSearchDTO.prototype, "overdraftLimitTo", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], WalletSearchDTO.prototype, "name", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], WalletSearchDTO.prototype, "userID", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ type: 'string' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Object)
], WalletSearchDTO.prototype, "type", void 0);
class UpdateWalletTransactionDTO {
}
exports.UpdateWalletTransactionDTO = UpdateWalletTransactionDTO;
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ type: 'boolean' }),
    (0, class_validator_1.IsBoolean)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Boolean)
], UpdateWalletTransactionDTO.prototype, "isVerified", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ type: 'boolean' }),
    (0, class_validator_1.IsBoolean)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Boolean)
], UpdateWalletTransactionDTO.prototype, "isFailed", void 0);
class CreateWalletTransactionDTO {
    constructor() {
        this.surcharge = 0;
    }
}
exports.CreateWalletTransactionDTO = CreateWalletTransactionDTO;
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    __metadata("design:type", Number)
], CreateWalletTransactionDTO.prototype, "amount", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.Min)(0),
    __metadata("design:type", Number)
], CreateWalletTransactionDTO.prototype, "surcharge", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ enum: wallet_enum_1.ETransactionType }),
    (0, class_validator_1.IsEnum)(wallet_enum_1.ETransactionType),
    __metadata("design:type", String)
], CreateWalletTransactionDTO.prototype, "type", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ enum: wallet_enum_1.ECurrency }),
    (0, class_validator_1.IsEnum)(wallet_enum_1.ECurrency),
    __metadata("design:type", String)
], CreateWalletTransactionDTO.prototype, "currency", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], CreateWalletTransactionDTO.prototype, "reason", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], CreateWalletTransactionDTO.prototype, "refCat", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsUrl)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], CreateWalletTransactionDTO.prototype, "redirectURL", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ enum: wallet_enum_1.ETransMethod }),
    (0, class_validator_1.IsEnum)(wallet_enum_1.ETransMethod),
    __metadata("design:type", String)
], CreateWalletTransactionDTO.prototype, "transMethod", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], CreateWalletTransactionDTO.prototype, "transactionReference", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'boolean' }),
    (0, class_validator_1.IsBoolean)(),
    __metadata("design:type", Boolean)
], CreateWalletTransactionDTO.prototype, "isVerified", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'boolean' }),
    (0, class_validator_1.IsBoolean)(),
    __metadata("design:type", Boolean)
], CreateWalletTransactionDTO.prototype, "isFailed", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsBoolean)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Boolean)
], CreateWalletTransactionDTO.prototype, "isTemporary", void 0);
class WalletTransactionSearchDTO extends search_dto_1.SearchQueryDto {
}
exports.WalletTransactionSearchDTO = WalletTransactionSearchDTO;
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsNumberString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Number)
], WalletTransactionSearchDTO.prototype, "amount", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsNumberString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Number)
], WalletTransactionSearchDTO.prototype, "amountFrom", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsNumberString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Number)
], WalletTransactionSearchDTO.prototype, "amountTo", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({}),
    (0, class_validator_1.IsNumberString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Number)
], WalletTransactionSearchDTO.prototype, "netBalanceBefore", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({}),
    (0, class_validator_1.IsNumberString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Number)
], WalletTransactionSearchDTO.prototype, "grossBalanceBefore", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ enum: wallet_enum_1.ETransactionType }),
    (0, class_validator_1.IsEnum)(wallet_enum_1.ETransactionType),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], WalletTransactionSearchDTO.prototype, "type", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ enum: wallet_enum_1.ECurrency }),
    (0, class_validator_1.IsEnum)(wallet_enum_1.ECurrency),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], WalletTransactionSearchDTO.prototype, "currency", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ type: 'string' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], WalletTransactionSearchDTO.prototype, "reason", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ type: 'string' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], WalletTransactionSearchDTO.prototype, "refCat", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ type: 'string' }),
    (0, class_validator_1.IsUUID)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], WalletTransactionSearchDTO.prototype, "userID", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ enum: wallet_enum_1.ETransMethod }),
    (0, class_validator_1.IsEnum)(wallet_enum_1.ETransMethod),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], WalletTransactionSearchDTO.prototype, "transMethod", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ type: 'boolean' }),
    (0, class_validator_1.IsBoolean)(),
    (0, class_validator_1.IsOptional)(),
    (0, to_boolean_decorator_1.ToBoolean)(),
    __metadata("design:type", Boolean)
], WalletTransactionSearchDTO.prototype, "isVerified", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ type: 'boolean' }),
    (0, class_validator_1.IsBoolean)(),
    (0, class_validator_1.IsOptional)(),
    (0, to_boolean_decorator_1.ToBoolean)(),
    __metadata("design:type", Boolean)
], WalletTransactionSearchDTO.prototype, "isFailed", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ type: 'string' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], WalletTransactionSearchDTO.prototype, "transactionReference", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsUUID)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], WalletTransactionSearchDTO.prototype, "walletId", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsString)({ each: true }),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Array)
], WalletTransactionSearchDTO.prototype, "walletIds", void 0);
//# sourceMappingURL=wallet.dto.js.map