import { WalletBalanceView, WalletEntity, WalletTransactionEntity } from './wallet.entity';
import { SearchQueryDto } from '../../dtos/search.dto';
import { ETransactionType, ECurrency, ETransMethod } from './wallet.enum';
export declare class CreateWalletDTO implements Partial<WalletEntity> {
    name?: string;
    userID?: string;
    orgID?: string;
    type?: any;
    allowOverdraft?: boolean;
    overdraftLimit?: number;
    active?: boolean;
}
declare const UpdateWalletDto_base: import("@nestjs/common").Type<Partial<CreateWalletDTO>>;
export declare class UpdateWalletDto extends UpdateWalletDto_base {
}
export declare class WalletSearchDTO extends SearchQueryDto<WalletBalanceView> implements Partial<WalletBalanceView> {
    grossBalance?: number;
    grossBalanceFrom?: number;
    grossBalanceTo?: number;
    netBalance?: number;
    netBalanceFrom?: number;
    netBalanceTo?: number;
    grossTotalCredit?: number;
    grossTotalCreditFrom?: number;
    grossTotalCreditTo?: number;
    grossTotalDebit?: number;
    grossTotalDebitFrom?: number;
    grossTotalDebitTo?: number;
    netTotalCredit?: number;
    netTotalCreditFrom?: number;
    netTotalCreditTo?: number;
    netTotalDebit?: number;
    netTotalDebitFrom?: number;
    netTotalDebitTo?: number;
    allowOverdraft?: boolean;
    overdraftLimit?: number;
    overdraftLimitFrom?: number;
    overdraftLimitTo?: number;
    name?: string;
    userID?: string;
    type?: any;
}
export declare class UpdateWalletTransactionDTO implements Partial<WalletTransactionEntity> {
    isVerified?: boolean;
    isFailed?: boolean;
}
export declare class CreateWalletTransactionDTO implements Partial<WalletTransactionEntity> {
    amount: number;
    surcharge: number;
    type: ETransactionType;
    currency: ECurrency;
    reason: string;
    refCat?: string;
    redirectURL?: string;
    transMethod: ETransMethod;
    transactionReference: string;
    isVerified: boolean;
    isFailed: boolean;
    isTemporary?: boolean;
}
export declare class WalletTransactionSearchDTO extends SearchQueryDto implements Partial<WalletTransactionEntity> {
    amount?: number;
    amountFrom?: number;
    amountTo?: number;
    netBalanceBefore?: number;
    grossBalanceBefore?: number;
    type?: ETransactionType;
    currency?: ECurrency;
    reason?: string;
    refCat?: string;
    userID?: string;
    transMethod?: ETransMethod;
    isVerified?: boolean;
    isFailed?: boolean;
    transactionReference?: string;
    walletId?: string;
    walletIds?: string[];
}
export {};
