import { CreateWalletDTO, UpdateWalletDto, WalletSearchDTO } from './wallet.dto';
import { IDDto } from '../../dtos/base.dto';
import { WalletService } from './wallet.service';
import { ETransactionType, ECurrency, ETransMethod } from './wallet.enum';
import { BaseController } from '../../controllers/base.controller';
import { WalletEntity } from './wallet.entity';
import { WalletTransactionService } from './wallet-transaction.service';
export declare class WalletController extends BaseController<WalletEntity, WalletSearchDTO> {
    service: WalletService;
    transService: WalletTransactionService;
    constructor(service: WalletService, transService: WalletTransactionService);
    getTransactionTypes(): string | ETransactionType[];
    getCurrencies(): string | ECurrency.naira[];
    getTransactionMethods(): string | ETransMethod[];
    create(data: CreateWalletDTO): Promise<string | WalletEntity>;
    update(data: UpdateWalletDto, param: IDDto): Promise<string | WalletEntity>;
    getByID(param: IDDto): Promise<string | import("./wallet.entity").WalletBalanceView>;
    getByUserID(param: IDDto): Promise<string | import("./wallet.entity").WalletBalanceView>;
    search(query: WalletSearchDTO): Promise<string | import("../..").ISearchResponse<WalletEntity>>;
    searchComputedView(query: WalletSearchDTO): Promise<string | import("../..").ISearchResponse<import("./wallet.entity").WalletBalanceView>>;
}
