import * as net from 'net';
import { TelnetSocket } from 'telnet-stream';
import { TelnetRequestDTO } from './telnet.dto';
export declare class TelnetService {
    protected pings: {
        [url_port: string]: TelnetSocket;
    };
    protected keyGen: (query: TelnetRequestDTO) => string;
    ping(query: TelnetRequestDTO): Promise<unknown>;
    stop(query: TelnetRequestDTO): void;
    clearAll(): void;
    get status(): {
        url: string;
        socket: {
            address: string | net.AddressInfo;
            status: {};
        };
    }[];
}
