"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TelnetController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const telnet_service_1 = require("./telnet.service");
const telnet_dto_1 = require("./telnet.dto");
const utility_service_1 = require("../../services/utility.service");
let TelnetController = class TelnetController {
    constructor(service) {
        this.service = service;
    }
    ping(query) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: this.service.ping(query),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    status() {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: this.service.status,
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    stop(query) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: this.service.stop(query),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    clearAll() {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: this.service.clearAll(),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
};
exports.TelnetController = TelnetController;
__decorate([
    (0, common_1.Get)(),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [telnet_dto_1.TelnetRequestDTO]),
    __metadata("design:returntype", void 0)
], TelnetController.prototype, "ping", null);
__decorate([
    (0, common_1.Get)('status'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], TelnetController.prototype, "status", null);
__decorate([
    (0, common_1.Delete)(),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [telnet_dto_1.TelnetRequestDTO]),
    __metadata("design:returntype", void 0)
], TelnetController.prototype, "stop", null);
__decorate([
    (0, common_1.Delete)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], TelnetController.prototype, "clearAll", null);
exports.TelnetController = TelnetController = __decorate([
    (0, common_1.Controller)('telnet'),
    (0, swagger_1.ApiTags)('Telnet'),
    (0, swagger_1.ApiBearerAuth)(),
    __metadata("design:paramtypes", [telnet_service_1.TelnetService])
], TelnetController);
//# sourceMappingURL=telnet.controller.js.map