// import { Injectable } from '@nestjs/common'; 
// import { FindOptionsWhere, Repository } from 'typeorm';
// import { InjectRepository } from '@nestjs/typeorm'; 
// import { BankDto, SearchPaymentDTO } from './payment.dto'; 
// import { PaystackService, PSCountry } from '@serene-dev/paystack';
// import { EPaymentCategory, EPaymentCurrency } from '../enums/payment.enum';
// import { evt } from './environment.service';
// import { PaymentEntity } from '../entities/payment.entity';
// import { BaseService } from '../../services/base.service';
// import { ETableName } from '../../enums/base.enum';
// @Injectable()
// export class PaymentService extends BaseService<
//   PaymentEntity,
//   SearchPaymentDTO
// > {
//   static override path = 'payments';
//   constructor(
//     @InjectRepository(PaymentEntity)
//     public override repo: Repository<PaymentEntity>,
//   ) {
//     super(repo, ETableName.payments);
//     this.queryStruct = [
//       { field: 'amount', lowerRange: 'amountFrom', upperRange: 'amountTo' },
//       { field: 'category' },
//       { field: 'currency' },
//       { field: 'customLeagueId' },
//       { field: 'customSeasonId' },
//       { field: 'customTeamId' },
//       { field: 'psTransactionNo' },
//       { field: 'reference' },
//     ];
//     setTimeout(() => {
//       PaystackService.setConfig({
//         currency: EPaymentCurrency.naira,
//         secretKey: evt.PS_SECRET_KEY,
//       });
//     }, 1000);
//   }
//   override formatSearchQuery = async (
//     query: SearchPaymentDTO,
//     auth?: IAuthParam,
//   ) => {
//     if (auth.isPublic) query.creatorId = auth.id;
//     return query;
//   };
//   override async getSingle(where: FindOptionsWhere<PaymentEntity>) {
//     return await this.repo.findOne({
//       where,
//       relations: {
//         creator: true, 
//       },
//     });
//   }
//   getBanks() {
//     return PaystackService.fetchBanks({ country: PSCountry.nigeria }).then(
//       (r) =>
//         r
//           .filter((x) => x)
//           .map<BankDto>((x) => ({ code: x.code, title: x.name, type: x.type })),
//     );
//   }
// }
//# sourceMappingURL=payment.service.js.map