"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.NotificationController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const notification_service_1 = require("./notification.service");
const notification_dto_1 = require("./notification.dto");
const base_controller_1 = require("../../controllers/base.controller");
const authentication_guard_1 = require("../authentication/authentication.guard");
const utility_service_1 = require("../../services/utility.service");
const search_dto_1 = require("../../dtos/search.dto");
const base_dto_1 = require("../../dtos/base.dto");
// @UseGuards(JwtAuthGuard)
let NotificationController = class NotificationController extends base_controller_1.BaseController {
    constructor(service, itemService) {
        super(service);
        this.service = service;
        this.itemService = itemService;
    }
    async create(body, auth) {
        try {
            body.creatorId = auth?.id;
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.create(body),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async search(query) {
        return super.search(query);
    }
    async getMySentNotifications(query, auth) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.getMySentNotifications(auth.id, query),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async getMyUnreadNotificationsCount(auth) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.getMyUnreadNotificationsCount(auth.id),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async getMyRecievedNotifications(query, auth) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.itemService.getMyReceivedNotifications(auth.id, query),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async toggleStatus(body, auth, param) {
        try {
            utility_service_1.UtilityClass.patchUpdater(body, auth);
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.toggleActiveStatus(param, body),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async resend(auth, param) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.resend(param.id, auth),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async markAsRead(auth, param) {
        try {
            const res = await this.itemService.markAsRead(param, auth.id);
            this.service.calculateSeen(res.notification.id);
            return utility_service_1.UtilityClass.handleSuccess({
                data: res,
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
};
exports.NotificationController = NotificationController;
__decorate([
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, authentication_guard_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [notification_dto_1.CreateNotificationDTO, Object]),
    __metadata("design:returntype", Promise)
], NotificationController.prototype, "create", null);
__decorate([
    (0, common_1.Get)('search'),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [notification_dto_1.NotificationQueryDTO]),
    __metadata("design:returntype", Promise)
], NotificationController.prototype, "search", null);
__decorate([
    (0, common_1.Get)('sent'),
    __param(0, (0, common_1.Query)()),
    __param(1, (0, authentication_guard_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [search_dto_1.SearchQueryDto, Object]),
    __metadata("design:returntype", Promise)
], NotificationController.prototype, "getMySentNotifications", null);
__decorate([
    (0, common_1.Get)('unreadCount'),
    __param(0, (0, authentication_guard_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], NotificationController.prototype, "getMyUnreadNotificationsCount", null);
__decorate([
    (0, common_1.Get)('received'),
    __param(0, (0, common_1.Query)()),
    __param(1, (0, authentication_guard_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [search_dto_1.SearchQueryDto, Object]),
    __metadata("design:returntype", Promise)
], NotificationController.prototype, "getMyRecievedNotifications", null);
__decorate([
    (0, common_1.Patch)('toggle/:id'),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, authentication_guard_1.AuthParam)()),
    __param(2, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [notification_dto_1.NotificationToggleActiveStatusDTO, Object, base_dto_1.IDDto]),
    __metadata("design:returntype", Promise)
], NotificationController.prototype, "toggleStatus", null);
__decorate([
    (0, common_1.Put)('resend/:id'),
    __param(0, (0, authentication_guard_1.AuthParam)()),
    __param(1, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, base_dto_1.IDDto]),
    __metadata("design:returntype", Promise)
], NotificationController.prototype, "resend", null);
__decorate([
    (0, common_1.Patch)('read/:id'),
    __param(0, (0, authentication_guard_1.AuthParam)()),
    __param(1, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, base_dto_1.IDDto]),
    __metadata("design:returntype", Promise)
], NotificationController.prototype, "markAsRead", null);
exports.NotificationController = NotificationController = __decorate([
    (0, swagger_1.ApiTags)(notification_service_1.NotificationService.tag),
    (0, common_1.Controller)(notification_service_1.NotificationService.path),
    __metadata("design:paramtypes", [notification_service_1.NotificationService,
        notification_service_1.NotificationItemService])
], NotificationController);
//# sourceMappingURL=notification.controller.js.map