"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessageService = void 0;
const common_1 = require("@nestjs/common");
const messages_entity_1 = require("./messages.entity");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const base_service_1 = require("../../services/base.service");
const base_enum_1 = require("../../enums/base.enum");
const search_enum_1 = require("../../enums/search.enum");
const messages_enum_1 = require("./messages.enum");
const mail_service_1 = require("../../services/mail.service");
const sms_service_1 = require("../../services/sms/sms.service");
let MessageService = class MessageService extends base_service_1.BaseService {
    constructor(repo, repoChild) {
        super(repo, base_enum_1.ETableName.message);
        this.repo = repo;
        this.repoChild = repoChild;
        this.queryStruct = [
            { field: 'refCat' },
            { field: 'refID' },
            { field: 'message', condition: search_enum_1.ESearchCondition.contains },
            {
                field: 'recipients',
                condition: search_enum_1.ESearchCondition.leftJoin,
                tableAlias: base_enum_1.ETableName.messageRecipient,
            },
            {
                field: 'recipient',
                // condition: ESearchCondition.leftJoin,
                tableAlias: base_enum_1.ETableName.messageRecipient,
            },
            { field: 'sender' },
            { field: 'status' },
        ];
        // this.queryStruct = [];
    }
    async getById(id) {
        return await this.repo.findOne({
            where: { id },
            relations: { recipients: true },
        });
    }
    async getByIds(ids) {
        return await this.repo.find({
            where: { id: (0, typeorm_2.In)(ids) },
            relations: { recipients: true },
        });
    }
    async create(body) {
        return new Promise(async (res, rej) => {
            let meesageID;
            await this.repo.manager
                .transaction(async (manager) => {
                const entity = new messages_entity_1.MessageEntity();
                Object.assign(entity, body);
                entity.recipientCount = entity.receiverIDs.length;
                const savedEntity = await manager.save(entity);
                await Promise.all(body.receiverIDs.map((r) => {
                    const recipient = new messages_entity_1.MessageRecipientEntity();
                    recipient.message = savedEntity;
                    recipient.recipient = r;
                    return manager.save(recipient);
                }));
                meesageID = savedEntity.id;
            })
                .catch((e) => rej(e));
            if (meesageID) {
                res(await this.getById(meesageID));
            }
        }).then(async (r) => await this.send([r]));
    }
    async createMultiple(items) {
        return new Promise(async (res, rej) => {
            await this.repo.manager
                .transaction(async (manager) => {
                res(await Promise.all(items.messages.map(async (body) => {
                    const entity = new messages_entity_1.MessageEntity();
                    Object.assign(entity, body);
                    const savedEntity = await manager.save(entity);
                    await Promise.all(body.receiverIDs.map((r) => {
                        const recipient = new messages_entity_1.MessageRecipientEntity();
                        recipient.message = savedEntity;
                        recipient.recipient = r;
                        return manager.save(recipient);
                    }));
                    return savedEntity.id;
                })));
            })
                .catch((e) => rej(e));
        }).then(async (r) => await this.send(await this.getByIds(r)));
    }
    send(messages) {
        return Promise.all(messages.map((message) => new Promise(async (res, rej) => {
            if (message.type === messages_enum_1.EMessageType.email) {
                await mail_service_1.MailService.sendMail({
                    to: message.receiverIDs,
                    text: message.isHTML ? undefined : message.message,
                    html: !message.isHTML ? undefined : message.message,
                    sender: message.sender,
                    from: message.sender,
                    subject: message.subject,
                });
                this.repo.update({ id: message.id }, { status: messages_enum_1.EMessageStatus.sent });
                message.recipients.map((r) => this.repoChild.update({ id: r.id }, { status: messages_enum_1.EMessageStatus.sent }));
                res(message.id);
            }
            else if (message.type === messages_enum_1.EMessageType.sms) {
                let recipientsFailedCount = 0, recipientsSuccessCount = 0;
                await Promise.all(message.recipients.map((recipient) => sms_service_1.SMSService.send({
                    message: message.message,
                    recipient: recipient.recipient,
                })
                    .then((response) => {
                    recipientsSuccessCount++;
                    return this.repoChild.update({ id: recipient.id }, { status: messages_enum_1.EMessageStatus.sent, response });
                })
                    .catch((e) => {
                    recipientsFailedCount++;
                    return this.repoChild.update({ id: recipient.id }, { status: messages_enum_1.EMessageStatus.failed, error: e });
                })));
                await this.repo.update({ id: message.id }, {
                    status: recipientsFailedCount == message.recipients.length
                        ? messages_enum_1.EMessageStatus.failed
                        : recipientsSuccessCount == message.recipients.length
                            ? messages_enum_1.EMessageStatus.sent
                            : messages_enum_1.EMessageStatus.mixed,
                });
                res(message.id);
            }
            else {
                rej(`No handler for message type ${message.type}`);
            }
        }).catch((e) => {
            message.status = messages_enum_1.EMessageStatus.failed;
            this.repo.update({ id: message.id }, { status: message.status });
            message.recipients.forEach((r) => {
                r.status = messages_enum_1.EMessageStatus.failed;
                r.error = e;
                this.repoChild.update({ id: r.id }, { status: r.status, error: e });
            });
            return message.id;
        }))).then((ids) => this.getByIds(ids));
    }
};
exports.MessageService = MessageService;
MessageService.path = 'message';
exports.MessageService = MessageService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(messages_entity_1.MessageEntity)),
    __param(1, (0, typeorm_1.InjectRepository)(messages_entity_1.MessageRecipientEntity)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository])
], MessageService);
//# sourceMappingURL=messages.service.js.map