import { MessageEntity, MessageRecipientEntity } from './messages.entity';
import { Repository } from 'typeorm';
import { BaseService } from '../../services/base.service';
import { CreateBatchMessagesDTO, CreateMessageDTO, MessageSearchDTO } from './messages.dto';
export declare class MessageService extends BaseService<MessageEntity, MessageSearchDTO> {
    protected repo: Repository<MessageEntity>;
    protected repoChild: Repository<MessageRecipientEntity>;
    static path: string;
    constructor(repo: Repository<MessageEntity>, repoChild: Repository<MessageRecipientEntity>);
    getById(id: string): Promise<MessageEntity>;
    getByIds(ids: string[]): Promise<MessageEntity[]>;
    create(body: CreateMessageDTO): Promise<MessageEntity[]>;
    createMultiple(items: CreateBatchMessagesDTO): Promise<MessageEntity[]>;
    protected send(messages: MessageEntity[]): Promise<MessageEntity[]>;
}
