"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.messageEntities = exports.MessageRecipientEntity = exports.MessageEntity = void 0;
const typeorm_1 = require("typeorm");
const base_enum_1 = require("../../enums/base.enum");
const base_entity_1 = require("../../entities/base.entity");
const messages_enum_1 = require("./messages.enum");
let MessageEntity = class MessageEntity extends base_entity_1.BaseEntity {
};
exports.MessageEntity = MessageEntity;
__decorate([
    (0, typeorm_1.Column)({ type: 'enum', enum: messages_enum_1.EMessageType }),
    __metadata("design:type", String)
], MessageEntity.prototype, "type", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'text' }),
    __metadata("design:type", String)
], MessageEntity.prototype, "message", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'boolean', default: false }),
    __metadata("design:type", Boolean)
], MessageEntity.prototype, "isHTML", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'text', nullable: true }),
    __metadata("design:type", String)
], MessageEntity.prototype, "subject", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'text', nullable: true }),
    __metadata("design:type", String)
], MessageEntity.prototype, "sender", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'text', nullable: true }),
    __metadata("design:type", String)
], MessageEntity.prototype, "refCat", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'text', nullable: true }),
    __metadata("design:type", String)
], MessageEntity.prototype, "refID", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'json', nullable: true }),
    __metadata("design:type", Array)
], MessageEntity.prototype, "receiverIDs", void 0);
__decorate([
    (0, typeorm_1.Column)({ default: 0 }),
    __metadata("design:type", Number)
], MessageEntity.prototype, "recipientCount", void 0);
__decorate([
    (0, typeorm_1.Column)({
        type: 'enum',
        enum: messages_enum_1.EMessageStatus,
        default: messages_enum_1.EMessageStatus.pending,
    }),
    __metadata("design:type", String)
], MessageEntity.prototype, "status", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => MessageRecipientEntity, (item) => item.message),
    __metadata("design:type", Array)
], MessageEntity.prototype, "recipients", void 0);
exports.MessageEntity = MessageEntity = __decorate([
    (0, typeorm_1.Entity)(base_enum_1.ETableName.message)
], MessageEntity);
let MessageRecipientEntity = class MessageRecipientEntity extends base_entity_1.BaseEntity {
};
exports.MessageRecipientEntity = MessageRecipientEntity;
__decorate([
    (0, typeorm_1.Column)({
        type: 'enum',
        enum: messages_enum_1.EMessageStatus,
        default: messages_enum_1.EMessageStatus.pending,
    }),
    __metadata("design:type", String)
], MessageRecipientEntity.prototype, "status", void 0);
__decorate([
    (0, typeorm_1.Column)({
        type: 'text',
    }),
    __metadata("design:type", String)
], MessageRecipientEntity.prototype, "recipient", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'json', nullable: true }),
    __metadata("design:type", Object)
], MessageRecipientEntity.prototype, "response", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'json', nullable: true }),
    __metadata("design:type", Object)
], MessageRecipientEntity.prototype, "error", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => MessageEntity, (item) => item.recipients),
    __metadata("design:type", MessageEntity)
], MessageRecipientEntity.prototype, "message", void 0);
exports.MessageRecipientEntity = MessageRecipientEntity = __decorate([
    (0, typeorm_1.Entity)(base_enum_1.ETableName.messageRecipient)
], MessageRecipientEntity);
exports.messageEntities = [MessageEntity, MessageRecipientEntity];
//# sourceMappingURL=messages.entity.js.map