"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessageSearchDTO = exports.CreateBatchMessagesDTO = exports.CreateMessageDTO = void 0;
const class_validator_1 = require("class-validator");
const swagger_1 = require("@nestjs/swagger");
const search_dto_1 = require("../../dtos/search.dto");
const base_dto_1 = require("../../dtos/base.dto");
const class_transformer_1 = require("class-transformer");
const messages_enum_1 = require("./messages.enum");
class CreateMessageDTO extends base_dto_1.BaseDto {
}
exports.CreateMessageDTO = CreateMessageDTO;
__decorate([
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], CreateMessageDTO.prototype, "message", void 0);
__decorate([
    (0, class_validator_1.IsArray)(),
    (0, swagger_1.ApiProperty)({
        type: [String],
    }),
    __metadata("design:type", Array)
], CreateMessageDTO.prototype, "receiverIDs", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    (0, swagger_1.ApiPropertyOptional)(),
    __metadata("design:type", String)
], CreateMessageDTO.prototype, "subject", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ enum: messages_enum_1.EMessageType }),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsEnum)(messages_enum_1.EMessageType),
    __metadata("design:type", String)
], CreateMessageDTO.prototype, "type", void 0);
__decorate([
    (0, class_validator_1.IsBoolean)(),
    (0, class_validator_1.IsOptional)(),
    (0, swagger_1.ApiPropertyOptional)(),
    __metadata("design:type", Boolean)
], CreateMessageDTO.prototype, "isHTML", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    (0, swagger_1.ApiPropertyOptional)(),
    __metadata("design:type", String)
], CreateMessageDTO.prototype, "sender", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    (0, swagger_1.ApiPropertyOptional)(),
    __metadata("design:type", String)
], CreateMessageDTO.prototype, "refID", void 0);
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, swagger_1.ApiPropertyOptional)(),
    __metadata("design:type", String)
], CreateMessageDTO.prototype, "refCat", void 0);
class CreateBatchMessagesDTO {
}
exports.CreateBatchMessagesDTO = CreateBatchMessagesDTO;
__decorate([
    (0, class_validator_1.ValidateNested)({ each: true }),
    (0, class_transformer_1.Type)(() => CreateMessageDTO),
    __metadata("design:type", Array)
], CreateBatchMessagesDTO.prototype, "messages", void 0);
class MessageSearchDTO extends search_dto_1.SearchQueryDto {
}
exports.MessageSearchDTO = MessageSearchDTO;
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], MessageSearchDTO.prototype, "recipient", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], MessageSearchDTO.prototype, "sender", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], MessageSearchDTO.prototype, "message", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], MessageSearchDTO.prototype, "refCat", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], MessageSearchDTO.prototype, "refID", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ enum: messages_enum_1.EMessageStatus }),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsEnum)(messages_enum_1.EMessageStatus),
    __metadata("design:type", String)
], MessageSearchDTO.prototype, "status", void 0);
//# sourceMappingURL=messages.dto.js.map