import { LogEntity } from './logs.entity';
import { Repository } from 'typeorm';
import { BaseService } from '../../services/base.service';
import { ILogBase, LogCreateMultipleDTO, LogCreateSingleDTO, LogSearchDTO } from './logs.dto';
import { Request } from 'express';
export declare class LogsService extends BaseService<LogEntity, LogSearchDTO> {
    protected repo: Repository<LogEntity>;
    static path: string;
    constructor(repo: Repository<LogEntity>);
    static parseHeader(request: Request): ILogBase;
    _create(data: LogCreateSingleDTO): Promise<LogEntity>;
    createMultiple(logs: LogCreateMultipleDTO): Promise<{
        message: string;
    }>;
}
export declare class LogsForInterceptorService extends LogsService {
    private readonly request;
    protected repo: Repository<LogEntity>;
    constructor(request: Request, repo: Repository<LogEntity>);
    _create(data: LogCreateSingleDTO): Promise<LogEntity>;
}
