import { BaseController } from '../../controllers/base.controller';
import { LogEntity } from './logs.entity';
import { LogsService } from './logs.service';
import { LogCreateMultipleDTO, LogCreateSingleDTO, LogSearchDTO } from './logs.dto';
export declare class LogsController extends BaseController<LogEntity, LogSearchDTO> {
    protected readonly service: LogsService;
    constructor(service: LogsService);
    create(body: LogCreateSingleDTO): Promise<string | LogEntity>;
    multiple(body: LogCreateMultipleDTO): Promise<string | {
        message: string;
    }>;
    search(query: LogSearchDTO): Promise<string | import("../..").ISearchResponse<LogEntity>>;
}
