"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LoggerDBService = void 0;
const common_1 = require("@nestjs/common");
const logger_db_entity_1 = require("./logger-db.entity");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const base_service_1 = require("../../services/base.service");
const base_enum_1 = require("../../enums/base.enum");
const utility_service_1 = require("../../services/utility.service");
const logger_service_1 = require("../../services/logger.service");
let LoggerDBService = class LoggerDBService extends base_service_1.BaseService {
    constructor(repo) {
        super(repo, base_enum_1.ETableName.loggerDb);
        this.repo = repo;
        this.searchV2 = ({ date, ...query }) => {
            const _date = date?.split('T')[0];
            return utility_service_1.UtilityClass.search(this.repo, query, {
                baseWhere: {
                    createdAt: _date
                        ? (0, typeorm_2.Between)(_date + 'T00:00:00', _date + 'T23:59:59')
                        : query.createdAt,
                },
            });
        };
        this.queryStruct = [];
        logger_service_1.logger$.subscribe(async (message) => {
            try {
                await this._create({
                    ...message,
                    message: message?.message != null
                        ? typeof message.message == 'string'
                            ? message.message
                            : JSON.stringify(message.message)?.slice(0, 500)
                        : null,
                    title: message?.title != null
                        ? typeof message.title == 'string'
                            ? message.title
                            : JSON.stringify(message.title)?.slice(0, 500)
                        : null,
                    refCat: `CONSOLE_${message.isError ? 'ERROR' : 'LOG'}`,
                });
            }
            catch (error) {
                console.error(error, 'logger db creation error');
            }
        });
    }
    async clear(query) {
        const subject = 'Clear LoggerDB';
        try {
            const errorMsg = `Deletion query must be provided`;
            if (Array.isArray(query)) {
                if (query.length == 0)
                    throw errorMsg;
            }
            else if (!Object.values(query).filter((x) => x != null).length)
                throw `Deletion query must be provided`;
            const res = await this.repo.delete(query);
            logger_service_1.logger.info(res, subject);
            return res;
        }
        catch (error) {
            logger_service_1.logger.error(error, subject);
            throw error;
        }
    }
    _create(data) {
        if (data?.message && typeof data.message != 'string')
            data.message = JSON.stringify(data.message);
        return super._create(data);
    }
};
exports.LoggerDBService = LoggerDBService;
LoggerDBService.path = 'logger-db';
exports.LoggerDBService = LoggerDBService = __decorate([
    (0, common_1.Injectable)({}),
    __param(0, (0, typeorm_1.InjectRepository)(logger_db_entity_1.LoggerDBEntity)),
    __metadata("design:paramtypes", [typeorm_2.Repository])
], LoggerDBService);
//# sourceMappingURL=logger-db.service.js.map