"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.EndpointLoggerViewEntity = exports.EndpointLoggerEntity = exports.LoggerDBEntity = void 0;
const typeorm_1 = require("typeorm");
const base_enum_1 = require("../../enums/base.enum");
const base_entity_1 = require("../../entities/base.entity");
let LoggerDBEntity = class LoggerDBEntity extends base_entity_1.BaseEntity {
};
exports.LoggerDBEntity = LoggerDBEntity;
__decorate([
    (0, typeorm_1.Column)({ type: 'text', nullable: true }),
    __metadata("design:type", String)
], LoggerDBEntity.prototype, "refCat", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'text', nullable: true }),
    __metadata("design:type", String)
], LoggerDBEntity.prototype, "refNo", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'text', nullable: true }),
    __metadata("design:type", String)
], LoggerDBEntity.prototype, "title", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'text', nullable: true }),
    __metadata("design:type", String)
], LoggerDBEntity.prototype, "message", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'boolean', nullable: true }),
    __metadata("design:type", Boolean)
], LoggerDBEntity.prototype, "isError", void 0);
exports.LoggerDBEntity = LoggerDBEntity = __decorate([
    (0, typeorm_1.Entity)(base_enum_1.ETableName.loggerDb)
], LoggerDBEntity);
let EndpointLoggerEntity = class EndpointLoggerEntity extends base_entity_1.BaseEntity {
};
exports.EndpointLoggerEntity = EndpointLoggerEntity;
__decorate([
    (0, typeorm_1.Column)({ type: 'text' }),
    __metadata("design:type", String)
], EndpointLoggerEntity.prototype, "endpoint", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'nvarchar', length: 15, default: 'GET' }),
    __metadata("design:type", String)
], EndpointLoggerEntity.prototype, "method", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'double' })
    // @CreateDateColumn()
    ,
    __metadata("design:type", Number)
], EndpointLoggerEntity.prototype, "inDateTime", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'double' }),
    __metadata("design:type", Number)
], EndpointLoggerEntity.prototype, "outDateTime", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'boolean', nullable: true }),
    __metadata("design:type", Boolean)
], EndpointLoggerEntity.prototype, "isError", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'json', nullable: true }),
    __metadata("design:type", Object)
], EndpointLoggerEntity.prototype, "errorJSON", void 0);
exports.EndpointLoggerEntity = EndpointLoggerEntity = __decorate([
    (0, typeorm_1.Entity)(base_enum_1.ETableName.loggerEndpoint)
], EndpointLoggerEntity);
let EndpointLoggerViewEntity = class EndpointLoggerViewEntity extends EndpointLoggerEntity {
};
exports.EndpointLoggerViewEntity = EndpointLoggerViewEntity;
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], EndpointLoggerViewEntity.prototype, "userAuthID", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], EndpointLoggerViewEntity.prototype, "firstName", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], EndpointLoggerViewEntity.prototype, "lastname", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", Number)
], EndpointLoggerViewEntity.prototype, "diffSeconds", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", Number)
], EndpointLoggerViewEntity.prototype, "diffMilliSeconds", void 0);
exports.EndpointLoggerViewEntity = EndpointLoggerViewEntity = __decorate([
    (0, typeorm_1.ViewEntity)({
        expression: `
  SELECT
a.id as userAuthID,
a.firstName,
a.lastname,
    (le.outDateTime - le.inDateTime) / 1000 AS diffSeconds,
    le.outDateTime - le.inDateTime AS diffMilliSeconds,
    le.endpoint,
    le.method,
    le.inDateTime,
    le.outDateTime,
    le.isError,
    le.id,
    le.createdAt,
    le.updatedAt
FROM
    ${base_enum_1.ETableName.loggerEndpoint} AS le
LEFT JOIN ${base_enum_1.ETableName.authentication} AS a
ON
    a.id = le.creatorId
ORDER BY
    le.createdAt
DESC
    ;
  `,
        name: base_enum_1.ETableName.loggerEndpointView,
    })
], EndpointLoggerViewEntity);
//# sourceMappingURL=logger-db.entity.js.map