"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.EndpointLoggerService = void 0;
const common_1 = require("@nestjs/common");
const logger_db_entity_1 = require("./logger-db.entity");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const base_service_1 = require("../../services/base.service");
const base_enum_1 = require("../../enums/base.enum");
const utility_service_1 = require("../../services/utility.service");
let EndpointLoggerService = class EndpointLoggerService extends base_service_1.BaseService {
    constructor(repo) {
        super(repo, base_enum_1.ETableName.loggerEndpoint);
        this.repo = repo;
        this.searchV2 = ({ date, ...query }) => {
            const _date = date?.split('T')[0];
            return utility_service_1.UtilityClass.search(this.repo, query, {
                baseWhere: {
                    createdAt: _date
                        ? (0, typeorm_2.Between)(_date + 'T00:00:00', _date + 'T23:59:59')
                        : query.createdAt,
                },
            });
        };
        this.queryStruct = [];
    }
    _create(data) {
        return super._create(data);
    }
};
exports.EndpointLoggerService = EndpointLoggerService;
EndpointLoggerService.path = 'logger-db';
exports.EndpointLoggerService = EndpointLoggerService = __decorate([
    (0, common_1.Injectable)({}),
    __param(0, (0, typeorm_1.InjectRepository)(logger_db_entity_1.EndpointLoggerEntity)),
    __metadata("design:paramtypes", [typeorm_2.Repository])
], EndpointLoggerService);
//# sourceMappingURL=endpoint-logger-db.service.js.map