"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ListsService = exports.ListsRoutePath = void 0;
const common_1 = require("@nestjs/common");
const lists_entity_1 = require("./lists.entity");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const route_path_class_1 = require("../../classes/route-path.class");
exports.ListsRoutePath = new route_path_class_1.RoutePath('lists');
let ListsService = class ListsService {
    constructor(repo, repoOptions) {
        this.repo = repo;
        this.repoOptions = repoOptions;
        // this.queryStruct = [];
    }
    getAll() {
        return this.repo.find({ relations: { options: true } }).then((r) => {
            r?.forEach((group) => (group.options = group.options.sort2('title')));
            return r.sort2('title');
        });
    }
    getAllGroupsOnly() {
        return this.repo.find().then((r) => {
            // r?.forEach((group) => group.options.forEach((o) => delete o.id));
            return r;
        });
    }
    getGroupByID(id) {
        return this.repo.findOne({ where: { id }, relations: { options: true } });
    }
    getSingleByValue(value) {
        return this.repo.findOne({
            where: { value },
            relations: { options: true },
        });
    }
    // getOptionByGroupValueAndOptionValue(groupValue: string, optionValue: string) {
    //   return this.repo.findOne({
    //     where: { value: groupValue },
    //     relations: { options: true },
    //   });
    // }
    getOptionsByGroupValue(value) {
        return this.repo
            .findOne({
            where: { value },
            relations: { options: true },
        })
            .then((r) => r?.options || []);
    }
    async createSingle(data) {
        const obj = Object.assign(new lists_entity_1.ListsEntity(), data);
        if (await this.repo.findOne({
            where: { value: obj.value },
            select: { id: true },
        }))
            throw `Group already exists`;
        const group = await this.repo.save(obj);
        await Promise.all(data.options.map((item) => {
            const option = Object.assign(new lists_entity_1.ListOptionsEntity(), item);
            option.group = group;
            return this.repoOptions.save(option);
        }));
        return this.getGroupByID(group.id);
    }
    async updateSingle(id, { options, ...data }) {
        const group = await this.getGroupByID(id);
        if (!group)
            throw `Id does not exist`;
        await this.repo.update({ id }, data);
        const optionsMap = options?.toMap('id');
        await Promise.all(group.options
            ?.filter((o) => !optionsMap[o.id])
            // .filter((o) => !options.some((so) => so.id === o.id))
            .map((o) => {
            try {
                return this.repoOptions.delete({ id: o.id }).catch();
            }
            catch (error) {
                return true;
            }
        }));
        // await this.repoOptions.delete({ group: { id: id } });
        await Promise.all(options.map(async (item) => {
            const option = Object.assign(new lists_entity_1.ListOptionsEntity(), item);
            option.group = group;
            if (!option.id)
                delete option.id;
            return this.repoOptions.save(option);
        }));
        return this.getGroupByID(id);
    }
    deleteSingle(id) {
        return Promise.all([
            this.repoOptions.delete({ group: { id } }),
            this.repo.delete({ id }),
        ]);
    }
};
exports.ListsService = ListsService;
exports.ListsService = ListsService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(lists_entity_1.ListsEntity)),
    __param(1, (0, typeorm_1.InjectRepository)(lists_entity_1.ListOptionsEntity)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository])
], ListsService);
//# sourceMappingURL=lists.service.js.map