"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ListsController = void 0;
const common_1 = require("@nestjs/common");
const authentication_guard_1 = require("../authentication/authentication.guard");
const lists_service_1 = require("./lists.service");
const swagger_1 = require("@nestjs/swagger");
const utility_service_1 = require("../../services/utility.service");
const lists_dto_1 = require("./lists.dto");
const base_dto_1 = require("../../dtos/base.dto");
let ListsController = class ListsController {
    constructor(service) {
        this.service = service;
    }
    async all() {
        return utility_service_1.UtilityClass.handleSuccess({ data: await this.service.getAll() });
    }
    async allGroupsOnly() {
        return utility_service_1.UtilityClass.handleSuccess({
            data: await this.service.getAllGroupsOnly(),
        });
    }
    async single(body) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.createSingle(body),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError({ error });
        }
    }
    async singleUpdate(param, body) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.updateSingle(param.id, body),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError({ error });
        }
    }
    async deleteSingle(param) {
        try {
            await this.service.deleteSingle(param.id);
            return utility_service_1.UtilityClass.handleSuccess({
                data: { success: true },
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError({ error });
        }
    }
    async getByGroup(param) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.getOptionsByGroupValue(param.group),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError({ error });
        }
    }
};
exports.ListsController = ListsController;
__decorate([
    (0, authentication_guard_1.PublicAuth)(),
    (0, common_1.Get)(''),
    (0, swagger_1.ApiResponse)({ type: [lists_dto_1.SaveListGroupDTO] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ListsController.prototype, "all", null);
__decorate([
    (0, common_1.Get)('groups'),
    (0, swagger_1.ApiResponse)({ type: [lists_dto_1.SaveListOption] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ListsController.prototype, "allGroupsOnly", null);
__decorate([
    (0, common_1.Post)(''),
    (0, swagger_1.ApiBearerAuth)(),
    (0, swagger_1.ApiResponse)({ type: [lists_dto_1.SaveListGroupDTO] }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [lists_dto_1.SaveListGroupDTO]),
    __metadata("design:returntype", Promise)
], ListsController.prototype, "single", null);
__decorate([
    (0, common_1.Put)(':id'),
    (0, swagger_1.ApiBearerAuth)(),
    (0, swagger_1.ApiResponse)({ type: [lists_dto_1.SaveListGroupDTO] }),
    __param(0, (0, common_1.Param)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [base_dto_1.IDDto, lists_dto_1.SaveListGroupDTO]),
    __metadata("design:returntype", Promise)
], ListsController.prototype, "singleUpdate", null);
__decorate([
    (0, common_1.Delete)(':id'),
    (0, swagger_1.ApiBearerAuth)(),
    __param(0, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [base_dto_1.IDDto]),
    __metadata("design:returntype", Promise)
], ListsController.prototype, "deleteSingle", null);
__decorate([
    (0, authentication_guard_1.PublicAuth)(),
    (0, common_1.Get)(':group'),
    (0, swagger_1.ApiResponse)({ type: [lists_dto_1.SaveListOption] }),
    __param(0, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [lists_dto_1.GetByGroupDTO]),
    __metadata("design:returntype", Promise)
], ListsController.prototype, "getByGroup", null);
exports.ListsController = ListsController = __decorate([
    (0, authentication_guard_1.PublicAuth)(),
    (0, swagger_1.ApiTags)(lists_service_1.ListsRoutePath.tag),
    (0, common_1.Controller)(lists_service_1.ListsRoutePath.path),
    __metadata("design:paramtypes", [lists_service_1.ListsService])
], ListsController);
//# sourceMappingURL=lists.controller.js.map