"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FormService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const form_generator_entity_1 = require("../form-generator.entity");
const base_service_1 = require("../../../services/base.service");
const base_enum_1 = require("../../../enums/base.enum");
const search_enum_1 = require("../../../enums/search.enum");
const form_field_service_1 = require("../form-field/form-field.service");
const form_generator_service_1 = require("../form-generator.service");
let FormService = class FormService extends base_service_1.BaseService {
    constructor(repo, formFieldService, formGeneratorService) {
        super(repo, base_enum_1.ETableName.form);
        this.repo = repo;
        this.formFieldService = formFieldService;
        this.formGeneratorService = formGeneratorService;
        this.queryStruct = [
            { field: 'name', condition: search_enum_1.ESearchCondition.contains },
            { field: 'description', condition: search_enum_1.ESearchCondition.contains },
            { field: 'refCat', condition: search_enum_1.ESearchCondition.equal },
        ];
    }
    getSingle(where) {
        return this.repo.findOne({
            where,
            relations: { fields: { baseField: true }, creator: true, updater: true },
            order: { fields: { createdAt: 'ASC', order: 'ASC' } },
        });
    }
    async _create({ fieldBankIDs, fields, ...data }, config) {
        if (data.slug)
            await this.checkIfUniqueBy({ slug: data.slug, refCat: data.refCat }, {
                errorMessage: `Slug ${data.slug} already exists`,
            });
        const entity = await this._save(data, config);
        if (fieldBankIDs?.length)
            await Promise.all(fieldBankIDs.map((bankFieldID, i) => this.formFieldService._create({
                bankFieldID,
                formID: entity.id,
                order: i + 1,
                refCat: data.refCat,
            })));
        if (fields?.length)
            await Promise.all(fields.map((field) => this.formFieldService._create({
                ...field,
                formID: entity.id,
                refCat: field.refCat || data.refCat,
            })));
        return config?.returnItem === false ? null : this.getById(entity.id);
    }
    async _updateByID(id, { fieldBankIDs, fields, replaceAllFields, ...data }, config) {
        this.checkIfExistsById(id, { errorMessage: `Form could not be found` });
        if (data.slug)
            await this.checkIfUniqueBy({ slug: data.slug, refCat: data.refCat, id: (0, typeorm_2.Not)(id) }, { errorMessage: 'Slug already exists' });
        await this.repo.update({ id }, data);
        if (replaceAllFields) {
            const ids = await this.formGeneratorService.repoFormField.find({
                where: { formId: id },
                select: { baseFieldId: true, id: true },
            });
            await this.formGeneratorService.repoFormField.delete({ formId: id });
            try {
                await this.formGeneratorService.repoFormFieldBank.delete({
                    id: (0, typeorm_2.In)(ids.map((x) => x.baseFieldId)),
                });
            }
            catch (error) { }
        }
        if (fieldBankIDs?.length)
            await Promise.all(fieldBankIDs.map((bankFieldID, i) => this.formFieldService._create({
                bankFieldID,
                formID: id,
                order: i + 1,
                refCat: data.refCat,
            })));
        if (fields?.length)
            await Promise.all(fields.map((field) => this.formFieldService._create({
                ...field,
                formID: id,
                refCat: field.refCat || data.refCat,
            })));
        return config?.returnItem === false ? null : this.getById(id);
    }
    // override async _updateChecks(id: string, body: UpdateFormDTO) {
    //   if (body.slug)
    //     await this.checkIfUniqueBy(
    //       { id: Not(id) },
    //       { errorMessage: 'Slug already exists' },
    //     );
    // }
    // getFormBySlug(slug: string) {
    //   return this.getSingle({ slug });
    // }
    async _deleteByID(id) {
        await this.formGeneratorService.repoFormField.delete({ form: { id } });
        return this.repo.delete({
            id,
        });
    }
    async _deleteByIDs(ids) {
        await this.formGeneratorService.repoFormField.delete({
            form: { id: (0, typeorm_2.In)(ids) },
        });
        return this.repo.delete({
            id: (0, typeorm_2.In)(ids),
        });
    }
};
exports.FormService = FormService;
exports.FormService = FormService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(form_generator_entity_1.FormEntity)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        form_field_service_1.FormFieldService,
        form_generator_service_1.FormGeneratorService])
], FormService);
//# sourceMappingURL=form.service.js.map