"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SearchFormDTO = exports.FormDto = exports.UpdateFormDTO = exports.SaveFormDTO = exports._SaveFormFieldDTO = void 0;
const class_validator_1 = require("class-validator");
const swagger_1 = require("@nestjs/swagger");
const class_transformer_1 = require("class-transformer");
const form_field_dto_1 = require("../form-field/form-field.dto");
const form_generator_dto_1 = require("../form-generator.dto");
const search_dto_1 = require("../../../dtos/search.dto");
class _SaveFormFieldDTO extends (0, swagger_1.OmitType)(form_field_dto_1.SaveFormFieldDTO, [
    'formID',
    'bankFieldID',
]) {
}
exports._SaveFormFieldDTO = _SaveFormFieldDTO;
class SaveFormDTO extends form_generator_dto_1.FormSharedDto {
}
exports.SaveFormDTO = SaveFormDTO;
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], SaveFormDTO.prototype, "name", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ required: false, maxLength: 255 }),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.MaxLength)(255),
    __metadata("design:type", String)
], SaveFormDTO.prototype, "slug", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ required: false }),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], SaveFormDTO.prototype, "description", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: [String] }),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsArray)(),
    (0, class_validator_1.IsString)({ each: true }),
    __metadata("design:type", Array)
], SaveFormDTO.prototype, "fieldBankIDs", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: [_SaveFormFieldDTO] }),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsArray)(),
    (0, class_validator_1.ValidateNested)({}),
    (0, class_transformer_1.Type)(() => _SaveFormFieldDTO),
    __metadata("design:type", Array)
], SaveFormDTO.prototype, "fields", void 0);
class UpdateFormDTO extends (0, swagger_1.PartialType)(SaveFormDTO) {
}
exports.UpdateFormDTO = UpdateFormDTO;
__decorate([
    (0, class_validator_1.IsBoolean)(),
    (0, class_validator_1.IsOptional)(),
    (0, swagger_1.ApiPropertyOptional)({
        description: `If true, updates the fields with the changes sent.\nElse, does a partial update of the fields`,
    }),
    __metadata("design:type", Boolean)
], UpdateFormDTO.prototype, "replaceAllFields", void 0);
class FormDto extends (0, swagger_1.PartialType)(SaveFormDTO) {
}
exports.FormDto = FormDto;
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], FormDto.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: [form_field_dto_1.FormFieldDto] }),
    __metadata("design:type", Array)
], FormDto.prototype, "fields", void 0);
class SearchFormDTO extends (0, swagger_1.IntersectionType)((search_dto_1.SearchQueryDto), (0, swagger_1.OmitType)(UpdateFormDTO, ['active'])) {
}
exports.SearchFormDTO = SearchFormDTO;
//# sourceMappingURL=form.dto.js.map