"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FormController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const utility_service_1 = require("../../../services/utility.service");
const form_dto_1 = require("./form.dto");
const base_dto_1 = require("../../../dtos/base.dto");
const form_service_1 = require("./form.service");
const authentication_guard_1 = require("../../authentication/authentication.guard");
const search_dto_1 = require("../../../dtos/search.dto");
const base_controller_1 = require("../../../controllers/base.controller");
const form_generator_route_path_1 = require("../form-generator.route-path");
let FormController = class FormController extends base_controller_1.BaseCRUDController {
    constructor(service) {
        super(service);
        this.service = service;
    }
    create(body, auth) {
        return super.create(body, auth);
    }
    async editForm(param, body, auth) {
        try {
            utility_service_1.UtilityClass.patchUpdater(body, auth);
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service._updateByID(param.id, body),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    // @Get('slug/:id')
    // @ApiResponse({ type: FormDto })
    // async getFormBySlug(@Param() param: IDDto) {
    //   try {
    //     return UtilityClass.handleSuccess({
    //       data: await this.service.getFormBySlug(param.id),
    //     });
    //   } catch (error) {
    //     return UtilityClass.handleError(error);
    //   }
    // }
    search(query) {
        return super.search(query);
    }
};
exports.FormController = FormController;
__decorate([
    (0, common_1.Post)(''),
    (0, swagger_1.ApiResponse)({ type: form_dto_1.FormDto }),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, authentication_guard_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [form_dto_1.SaveFormDTO, Object]),
    __metadata("design:returntype", void 0)
], FormController.prototype, "create", null);
__decorate([
    (0, common_1.Put)(':id'),
    (0, swagger_1.ApiResponse)({ type: form_dto_1.FormDto }),
    __param(0, (0, common_1.Param)()),
    __param(1, (0, common_1.Body)()),
    __param(2, (0, authentication_guard_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [base_dto_1.IDDto,
        form_dto_1.UpdateFormDTO, Object]),
    __metadata("design:returntype", Promise)
], FormController.prototype, "editForm", null);
__decorate([
    (0, authentication_guard_1.PublicAuth)(),
    (0, common_1.Get)('search'),
    (0, swagger_1.ApiResponse)({ type: search_dto_1.SearchResponseDto }),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [form_dto_1.SearchFormDTO]),
    __metadata("design:returntype", void 0)
], FormController.prototype, "search", null);
exports.FormController = FormController = __decorate([
    (0, swagger_1.ApiTags)(form_generator_route_path_1.FormRoutePath.tag),
    (0, common_1.Controller)(form_generator_route_path_1.FormRoutePath.path),
    __metadata("design:paramtypes", [form_service_1.FormService])
], FormController);
//# sourceMappingURL=form.controller.js.map