"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FormEntity = exports.FormFieldEntity = exports.FormFieldBankEntity = exports.FormSharedEntity = void 0;
const typeorm_1 = require("typeorm");
const base_enum_1 = require("../../enums/base.enum");
const base_entity_1 = require("../../entities/base.entity");
const form_generator_enum_1 = require("./form-generator.enum");
class FormSharedEntity extends base_entity_1.BaseEntity {
}
exports.FormSharedEntity = FormSharedEntity;
__decorate([
    (0, typeorm_1.Column)({ type: 'nvarchar', length: 255, nullable: true }),
    __metadata("design:type", String)
], FormSharedEntity.prototype, "refCat", void 0);
let FormFieldBankEntity = class FormFieldBankEntity extends FormSharedEntity {
    get optionsMap() {
        return this.options?.toMap('value');
    }
};
exports.FormFieldBankEntity = FormFieldBankEntity;
__decorate([
    (0, typeorm_1.Column)({ type: 'nvarchar', length: 255 }),
    __metadata("design:type", String)
], FormFieldBankEntity.prototype, "field", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'json', nullable: true }),
    __metadata("design:type", Object)
], FormFieldBankEntity.prototype, "defaultValue", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], FormFieldBankEntity.prototype, "hint", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], FormFieldBankEntity.prototype, "label", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", Number)
], FormFieldBankEntity.prototype, "max", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", Number)
], FormFieldBankEntity.prototype, "min", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", Number)
], FormFieldBankEntity.prototype, "decimalPlaces", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'boolean', nullable: true }),
    __metadata("design:type", Boolean)
], FormFieldBankEntity.prototype, "multiple", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'boolean', nullable: true }),
    __metadata("design:type", Boolean)
], FormFieldBankEntity.prototype, "nullable", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'json', nullable: true }),
    __metadata("design:type", Array)
], FormFieldBankEntity.prototype, "options", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], FormFieldBankEntity.prototype, "placeholder", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'boolean', nullable: true }),
    __metadata("design:type", Boolean)
], FormFieldBankEntity.prototype, "readonly", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'boolean', nullable: true }),
    __metadata("design:type", Boolean)
], FormFieldBankEntity.prototype, "hidden", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'boolean', nullable: true }),
    __metadata("design:type", Boolean)
], FormFieldBankEntity.prototype, "required", void 0);
__decorate([
    (0, typeorm_1.Column)({ enum: form_generator_enum_1.EInputType, type: 'enum', default: form_generator_enum_1.EInputType.text }),
    __metadata("design:type", String)
], FormFieldBankEntity.prototype, "type", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => FormFieldEntity, (item) => item.baseField),
    __metadata("design:type", Object)
], FormFieldBankEntity.prototype, "formFields", void 0);
exports.FormFieldBankEntity = FormFieldBankEntity = __decorate([
    (0, typeorm_1.Entity)(base_enum_1.ETableName.formFieldBank)
], FormFieldBankEntity);
let FormFieldEntity = class FormFieldEntity extends FormSharedEntity {
};
exports.FormFieldEntity = FormFieldEntity;
__decorate([
    (0, typeorm_1.ManyToOne)(() => FormFieldBankEntity, (item) => item.formFields),
    __metadata("design:type", Object)
], FormFieldEntity.prototype, "baseField", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true, select: false }),
    __metadata("design:type", String)
], FormFieldEntity.prototype, "baseFieldId", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => FormEntity, (item) => item.fields),
    __metadata("design:type", Object)
], FormFieldEntity.prototype, "form", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true, select: false }),
    __metadata("design:type", String)
], FormFieldEntity.prototype, "formId", void 0);
exports.FormFieldEntity = FormFieldEntity = __decorate([
    (0, typeorm_1.Entity)(base_enum_1.ETableName.formField)
], FormFieldEntity);
let FormEntity = class FormEntity extends FormSharedEntity {
};
exports.FormEntity = FormEntity;
__decorate([
    (0, typeorm_1.Column)({ type: 'text' }),
    __metadata("design:type", String)
], FormEntity.prototype, "name", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'text', nullable: true }),
    __metadata("design:type", String)
], FormEntity.prototype, "description", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'nvarchar', length: 255, nullable: true }),
    __metadata("design:type", String)
], FormEntity.prototype, "slug", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => FormFieldEntity, (item) => item.form),
    __metadata("design:type", Object)
], FormEntity.prototype, "fields", void 0);
exports.FormEntity = FormEntity = __decorate([
    (0, typeorm_1.Entity)(base_enum_1.ETableName.form)
], FormEntity);
//# sourceMappingURL=form-generator.entity.js.map