import { Relation } from 'typeorm';
import { BaseEntity } from '../../entities/base.entity';
import { EInputType } from './form-generator.enum';
export declare class FormSharedEntity<T = any> extends BaseEntity<T> {
    refCat?: string;
}
export declare class FormFieldBankEntity extends FormSharedEntity<FormFieldBankEntity> {
    field: string;
    defaultValue?: any;
    hint?: string;
    label?: string;
    max?: number;
    min?: number;
    decimalPlaces?: number;
    multiple?: boolean;
    nullable?: boolean;
    options?: {
        value: any;
        label: string;
    }[];
    placeholder?: string;
    readonly?: boolean;
    hidden?: boolean;
    required?: boolean;
    type: EInputType;
    formFields: Relation<FormFieldEntity[]>;
    get optionsMap(): {
        [x: string]: {
            value: any;
            label: string;
        };
    };
}
export declare class FormFieldEntity extends FormSharedEntity<FormFieldEntity> {
    baseField?: Relation<FormFieldBankEntity>;
    baseFieldId?: string;
    form?: Relation<FormEntity>;
    formId?: string;
}
export declare class FormEntity extends FormSharedEntity<FormEntity> {
    name: string;
    description?: string;
    slug?: string;
    fields: Relation<FormFieldEntity[]>;
}
