"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SearchFormFieldDTO = exports.FormFieldDto = exports.UpdateFormFieldDTO = exports.SaveFormFieldDTO = void 0;
const class_validator_1 = require("class-validator");
const search_dto_1 = require("../../../dtos/search.dto");
const swagger_1 = require("@nestjs/swagger");
const form_field_bank_dto_1 = require("../form-field-bank/form-field-bank.dto");
const form_generator_dto_1 = require("../form-generator.dto");
class SaveFormFieldDTO extends (0, swagger_1.IntersectionType)((0, swagger_1.PartialType)(form_field_bank_dto_1.SaveFormFieldBankDTO), form_generator_dto_1.FormSharedDto) {
}
exports.SaveFormFieldDTO = SaveFormFieldDTO;
__decorate([
    (0, swagger_1.ApiProperty)({ required: false }),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    __metadata("design:type", Number)
], SaveFormFieldDTO.prototype, "order", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ required: false }),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], SaveFormFieldDTO.prototype, "formID", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ required: false }),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], SaveFormFieldDTO.prototype, "bankFieldID", void 0);
class UpdateFormFieldDTO extends (0, swagger_1.PartialType)(SaveFormFieldDTO) {
}
exports.UpdateFormFieldDTO = UpdateFormFieldDTO;
__decorate([
    (0, class_validator_1.IsBoolean)(),
    (0, class_validator_1.IsOptional)(),
    (0, swagger_1.ApiPropertyOptional)({
        description: `If true, updates the record in the bank with the changes sent.\nElse, creates a new record in the bank`,
    }),
    __metadata("design:type", Boolean)
], UpdateFormFieldDTO.prototype, "updateBank", void 0);
class FormFieldDto {
}
exports.FormFieldDto = FormFieldDto;
__decorate([
    (0, swagger_1.ApiProperty)({ required: false }),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    __metadata("design:type", Number)
], FormFieldDto.prototype, "order", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], FormFieldDto.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: form_field_bank_dto_1.FormFieldBankDTO }),
    __metadata("design:type", Object)
], FormFieldDto.prototype, "baseField", void 0);
class SearchFormFieldDTO extends (0, swagger_1.IntersectionType)((search_dto_1.SearchQueryDto), form_field_bank_dto_1.SearchFormFieldBankDTO, (0, swagger_1.OmitType)((0, swagger_1.PartialType)(SaveFormFieldDTO), ['active'])) {
}
exports.SearchFormFieldDTO = SearchFormFieldDTO;
__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    (0, swagger_1.ApiPropertyOptional)(),
    __metadata("design:type", String)
], SearchFormFieldDTO.prototype, "formName", void 0);
//# sourceMappingURL=form-field.dto.js.map