"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FormFieldBankService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const form_generator_entity_1 = require("../form-generator.entity");
const base_service_1 = require("../../../services/base.service");
const base_enum_1 = require("../../../enums/base.enum");
const search_enum_1 = require("../../../enums/search.enum");
const utility_service_1 = require("../../../services/utility.service");
let FormFieldBankService = class FormFieldBankService extends base_service_1.BaseService {
    constructor(repo, repoFormField) {
        super(repo, base_enum_1.ETableName.formFieldBank);
        this.repo = repo;
        this.repoFormField = repoFormField;
        this.queryStruct = [
            { field: 'field', condition: search_enum_1.ESearchCondition.contains },
            { field: 'hint', condition: search_enum_1.ESearchCondition.contains },
            { field: 'label', condition: search_enum_1.ESearchCondition.contains },
            { field: 'max', condition: search_enum_1.ESearchCondition.equal },
            { field: 'min', condition: search_enum_1.ESearchCondition.equal },
            { field: 'multiple', condition: search_enum_1.ESearchCondition.equal },
            { field: 'placeholder', condition: search_enum_1.ESearchCondition.contains },
            { field: 'readonly', condition: search_enum_1.ESearchCondition.equal },
            { field: 'hidden', condition: search_enum_1.ESearchCondition.equal },
            { field: 'required', condition: search_enum_1.ESearchCondition.equal },
            { field: 'type', condition: search_enum_1.ESearchCondition.equal },
        ];
        this.deletionStyle = base_enum_1.EDeletionType.soft;
    }
    getSingle(where) {
        return this.repo.findOne({
            where,
            relations: { creator: true, updater: true },
        });
    }
    async _checkIfBoundForms(formFieldBankIDs) {
        if (await this.repoFormField.exist({
            where: { baseFieldId: (0, typeorm_2.In)(formFieldBankIDs) },
        }))
            utility_service_1.UtilityClass.throwError({
                statusCode: 400,
                message: `Form Fields are using this item`,
            });
    }
    async _deleteChecks(ids) {
        await Promise.all([
            this._checkIfBoundForms(ids),
            this.checkIfExternalBounds?.(ids),
        ]);
    }
};
exports.FormFieldBankService = FormFieldBankService;
exports.FormFieldBankService = FormFieldBankService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(form_generator_entity_1.FormFieldBankEntity)),
    __param(1, (0, typeorm_1.InjectRepository)(form_generator_entity_1.FormFieldEntity)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository])
], FormFieldBankService);
//# sourceMappingURL=form-field-bank.service.js.map