"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FormFieldBankController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const utility_service_1 = require("../../../services/utility.service");
const form_field_bank_dto_1 = require("./form-field-bank.dto");
const base_dto_1 = require("../../../dtos/base.dto");
const authentication_guard_1 = require("../../authentication/authentication.guard");
const search_dto_1 = require("../../../dtos/search.dto");
const base_controller_1 = require("../../../controllers/base.controller");
const form_generator_enum_1 = require("../form-generator.enum");
const form_field_bank_service_1 = require("./form-field-bank.service");
const form_generator_route_path_1 = require("../form-generator.route-path");
let FormFieldBankController = class FormFieldBankController extends base_controller_1.BaseCRUDController {
    constructor(service) {
        super(service);
        this.service = service;
    }
    create(body, auth) {
        return super.create(body, auth);
    }
    updateByID(param, body, auth) {
        return super.updateByID(param, body, auth);
    }
    search(query) {
        return super.search(query);
    }
    async getInputTypes() {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: Object.values(form_generator_enum_1.EInputType),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
};
exports.FormFieldBankController = FormFieldBankController;
__decorate([
    (0, common_1.Post)(),
    (0, swagger_1.ApiResponse)({ type: form_field_bank_dto_1.FormFieldBankDTO }),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, authentication_guard_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [form_field_bank_dto_1.SaveFormFieldBankDTO, Object]),
    __metadata("design:returntype", void 0)
], FormFieldBankController.prototype, "create", null);
__decorate([
    (0, common_1.Put)(`:id`),
    (0, swagger_1.ApiResponse)({ type: form_field_bank_dto_1.FormFieldBankDTO }),
    __param(0, (0, common_1.Param)()),
    __param(1, (0, common_1.Body)()),
    __param(2, (0, authentication_guard_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [base_dto_1.IDDto,
        form_field_bank_dto_1.UpdateFormFieldBankDTO, Object]),
    __metadata("design:returntype", void 0)
], FormFieldBankController.prototype, "updateByID", null);
__decorate([
    (0, common_1.Get)(`search`),
    (0, swagger_1.ApiResponse)({ type: search_dto_1.SearchResponseDto }),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [form_field_bank_dto_1.SearchFormFieldBankDTO]),
    __metadata("design:returntype", void 0)
], FormFieldBankController.prototype, "search", null);
__decorate([
    (0, common_1.Get)('inputTypes'),
    (0, swagger_1.ApiResponse)({ type: [String] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], FormFieldBankController.prototype, "getInputTypes", null);
exports.FormFieldBankController = FormFieldBankController = __decorate([
    (0, swagger_1.ApiTags)(form_generator_route_path_1.FormFieldBankRoutePath.tag),
    (0, common_1.Controller)(form_generator_route_path_1.FormFieldBankRoutePath.path),
    __metadata("design:paramtypes", [form_field_bank_service_1.FormFieldBankService])
], FormFieldBankController);
//# sourceMappingURL=form-field-bank.controller.js.map