import { SaveFormFieldBankDTO, SearchFormFieldBankDTO, UpdateFormFieldBankDTO } from './form-field-bank.dto';
import { IDDto } from '../../../dtos/base.dto';
import { IAuthParam } from '../../authentication/authentication.interface';
import { BaseCRUDController } from '../../../controllers/base.controller';
import { FormFieldBankEntity } from '../form-generator.entity';
import { EInputType } from '../form-generator.enum';
import { FormFieldBankService } from './form-field-bank.service';
export declare class FormFieldBankController extends BaseCRUDController<FormFieldBankEntity, SearchFormFieldBankDTO> {
    protected service: FormFieldBankService;
    constructor(service: FormFieldBankService);
    create(body: SaveFormFieldBankDTO, auth: IAuthParam): string | Promise<FormFieldBankEntity>;
    updateByID(param: IDDto, body: UpdateFormFieldBankDTO, auth: IAuthParam): string | Promise<FormFieldBankEntity>;
    search(query: SearchFormFieldBankDTO): Promise<string | import("../../..").ISearchResponse<FormFieldBankEntity>>;
    getInputTypes(): Promise<string | EInputType[]>;
}
