"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FileModule = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const base_module_1 = require("../base.module");
const file_entity_1 = require("../../entities/file.entity");
const file_service_1 = require("../../services/file.service");
const file_controller_1 = require("../../controllers/file.controller");
const likes_service_1 = require("../../services/likes.service");
const likes_entity_1 = require("../../entities/likes.entity");
const token_service_1 = require("../../services/token.service");
const jwt_1 = require("@nestjs/jwt");
const platform_express_1 = require("@nestjs/platform-express");
const environment_service_1 = require("../../services/environment.service");
const common_2 = require("@nestjs/common");
let FileModule = class FileModule extends base_module_1.BaseModule {
};
exports.FileModule = FileModule;
FileModule.entities = [file_entity_1.FileEntity, likes_entity_1.LikesEntity, file_entity_1.FileContentEntity];
FileModule.services = [file_service_1.FileService, likes_service_1.LikesService, token_service_1.TokenService];
FileModule.controllers = [file_controller_1.FileController];
exports.FileModule = FileModule = __decorate([
    (0, common_2.Global)(),
    (0, common_1.Module)({
        imports: [
            typeorm_1.TypeOrmModule.forFeature(FileModule.entities),
            jwt_1.JwtModule,
            platform_express_1.MulterModule.registerAsync({
                useClass: environment_service_1.SDKEnvironmentService,
            }),
        ],
        providers: FileModule.services,
        controllers: FileModule.controllers,
        exports: [...FileModule.services],
    })
], FileModule);
//# sourceMappingURL=file.module.js.map