import { BaseService } from '../../services/base.service';
import { CreateFAQDto, SearchFAQGroupQueryDto, SearchFAQQueryDto } from './faq.dto';
import { FAQGroupEntity, FAQEntity } from './faq.entity';
import { FindOptionsWhere, Repository } from 'typeorm';
import { IAuthParam } from '../authentication/authentication.interface';
export declare class FAQGroupService extends BaseService<FAQGroupEntity, SearchFAQGroupQueryDto> {
    repo: Repository<FAQGroupEntity>;
    constructor(repo: Repository<FAQGroupEntity>);
    getSingle(where: FindOptionsWhere<FAQEntity>, auth?: IAuthParam): Promise<FAQGroupEntity>;
}
export declare class FAQService extends BaseService<FAQEntity, SearchFAQQueryDto> {
    repo: Repository<FAQEntity>;
    groupService: FAQGroupService;
    constructor(repo: Repository<FAQEntity>, groupService: FAQGroupService);
    getSingle(where: FindOptionsWhere<FAQEntity>, auth?: IAuthParam): Promise<FAQEntity>;
    _createChecks(data: CreateFAQDto): Promise<void>;
    _updateChecks(id: string, data: CreateFAQDto): Promise<void>;
}
