"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FAQController = exports.FAQGroupController = exports.FAQGroupRoutePath = exports.FAQRoutePath = void 0;
const common_1 = require("@nestjs/common");
const faq_service_1 = require("./faq.service");
const base_controller_1 = require("../../controllers/base.controller");
const faq_dto_1 = require("./faq.dto");
const swagger_1 = require("@nestjs/swagger");
const base_dto_1 = require("../../dtos/base.dto");
const search_dto_1 = require("../../dtos/search.dto");
const authentication_guard_1 = require("../authentication/authentication.guard");
const route_path_class_1 = require("../../classes/route-path.class");
exports.FAQRoutePath = new route_path_class_1.RoutePath('faq');
exports.FAQGroupRoutePath = new route_path_class_1.RoutePath('group', exports.FAQRoutePath);
let FAQGroupController = class FAQGroupController extends base_controller_1.BaseCRUDController {
    constructor(service) {
        super(service);
        this.service = service;
    }
    create(body, auth) {
        return super.create(body, auth);
    }
    updateByID(param, body, auth) {
        return super.updateByID(param, body, auth);
    }
    async search(query) {
        return super.search(query);
    }
};
exports.FAQGroupController = FAQGroupController;
__decorate([
    (0, swagger_1.ApiBearerAuth)(),
    (0, common_1.Post)(''),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, authentication_guard_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [faq_dto_1.CreateFAQGroupDto, Object]),
    __metadata("design:returntype", void 0)
], FAQGroupController.prototype, "create", null);
__decorate([
    (0, swagger_1.ApiBearerAuth)(),
    (0, common_1.Put)(':id'),
    __param(0, (0, common_1.Param)()),
    __param(1, (0, common_1.Body)()),
    __param(2, (0, authentication_guard_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [base_dto_1.IDDto,
        faq_dto_1.UpdateFAQGroupDto, Object]),
    __metadata("design:returntype", void 0)
], FAQGroupController.prototype, "updateByID", null);
__decorate([
    (0, common_1.Get)('search'),
    (0, authentication_guard_1.PublicAuth)(),
    (0, swagger_1.ApiResponse)({ type: search_dto_1.SearchResponseDto }),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [faq_dto_1.SearchFAQGroupQueryDto]),
    __metadata("design:returntype", Promise)
], FAQGroupController.prototype, "search", null);
exports.FAQGroupController = FAQGroupController = __decorate([
    (0, swagger_1.ApiTags)(exports.FAQGroupRoutePath.tag),
    (0, common_1.Controller)(exports.FAQGroupRoutePath.path),
    __metadata("design:paramtypes", [faq_service_1.FAQGroupService])
], FAQGroupController);
let FAQController = class FAQController extends base_controller_1.BaseCRUDController {
    constructor(service) {
        super(service);
        this.service = service;
    }
    create(body, auth) {
        return super.create(body, auth);
    }
    updateByID(param, body, auth) {
        return super.updateByID(param, body, auth);
    }
    async search(query) {
        return super.search(query);
    }
};
exports.FAQController = FAQController;
__decorate([
    (0, swagger_1.ApiBearerAuth)(),
    (0, common_1.Post)(''),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, authentication_guard_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [faq_dto_1.CreateFAQDto, Object]),
    __metadata("design:returntype", void 0)
], FAQController.prototype, "create", null);
__decorate([
    (0, swagger_1.ApiBearerAuth)(),
    (0, common_1.Put)(':id'),
    __param(0, (0, common_1.Param)()),
    __param(1, (0, common_1.Body)()),
    __param(2, (0, authentication_guard_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [base_dto_1.IDDto,
        faq_dto_1.UpdateFAQDto, Object]),
    __metadata("design:returntype", void 0)
], FAQController.prototype, "updateByID", null);
__decorate([
    (0, common_1.Get)('search'),
    (0, authentication_guard_1.PublicAuth)(),
    (0, swagger_1.ApiResponse)({ type: search_dto_1.SearchResponseDto }),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [faq_dto_1.SearchFAQQueryDto]),
    __metadata("design:returntype", Promise)
], FAQController.prototype, "search", null);
exports.FAQController = FAQController = __decorate([
    (0, swagger_1.ApiTags)(exports.FAQRoutePath.tag),
    (0, common_1.Controller)(exports.FAQRoutePath.path),
    __metadata("design:paramtypes", [faq_service_1.FAQService])
], FAQController);
//# sourceMappingURL=faq.controller.js.map